(* dir-tree.sml *)
(*
 * construct the directory tree for an installation
 *
 *)

structure DirTree =
struct

  datatype dir_tree = DT of (string * dir_tree) list
  
  fun mkDir (n) = OS.FileSys.mkDir (n) handle e => if (OS.FileSys.isDir (n)) 
                                                     then () 
                                                   else raise e
                                                       
                    
  fun construct (DT l) =
      let fun dodir(n,dt) =
               (mkDir (n);
		OS.FileSys.chDir (n);
		construct (dt);
		OS.FileSys.chDir "..")
       in app dodir l
      end

  val os_tree = DT [("Intel 32",DT []), 
                    ("OS Independent",DT [])] 
    
  val lang_tree = DT [("0009-English",os_tree), 
                      ("Language Independent",os_tree)] 
    
  val setup_tree = DT [("Compressed Files",lang_tree), 
                       ("Uncompressed Files",lang_tree)]
    
  (* this has been modified to attempt to build a valid Media/Default
   * directory, but it is still not recognized as a Media directory
   * by IS 6.2, so we have to use the Media Wizard interactively to build
   * the media directory. [dbm]

  val media_tree =
      DT [("Default",DT [("Disk Images", DT[("Disk1",DT[])]),
			 ("Log Files", DT[]),
			 ("Report Files", DT[])])]
  *)

  val default_tree =
      DT [("Component Definitions",DT []), 
	  ("File Groups",DT []), 
	  ("Registry Entries",DT []),
	  ("Script Files",DT []), 
	  ("Setup Files",setup_tree),
	  ("Shell Objects",DT []),
	  ("String Tables",DT [("0009-English",DT [])]),
	  ("Text Substitutions",DT [])]
          (*, ("Media",media_tree)]*)

end (* structure DirTree *)
