(* batch.sml *)

structure BatchFile = struct
  
  fun concatP [] = ""
    | concatP [x] = x
    | concatP (x::xs) = OS.Path.concat (x,concatP (xs))

  fun create (target) = let
    val s = TextIO.openOut (concatP [target, "gen.bat"])
    fun out [] = TextIO.output (s,"\n")
      | out (x::xs) = (TextIO.output (s,x); out xs)
  in
    out ["compile -I\"c:\\program files\\installshield\\installshield professional 6.2\\include\" \"Script Files\\setup.rul\""];
    out ["isbuild -P\"",target,"\" -m\"default\""];
    TextIO.closeOut (s)
  end

end