(* basic.sml *)

structure Basic =
struct

val concatP = Util.concatP

fun dump (target,version) =
let val project_ipr_n = concatP [target,version^".ipr"]
    val default_fgl_n = concatP [target,"Component Definitions","Default.fgl"]
    val default_rge_n = concatP [target,"Registry Entries","Default.rge"]
    val so_default_shl_n = concatP [target,"Shell Objects","Default.shl"]
    val default_shl_n = concatP [target,"String Tables","Default.shl"]
    val setup_tsb_n = concatP [target,"Text Substitutions","Setup.tsb"]
    val build_tsb_n = concatP [target,"Text Substitutions","Build.tsb"]
(*    val default_mda_n = concatP [target,"Media","Default","default.mda"] *)
    val value_shl_n = concatP [target,"String Tables","0009-English","value.shl"]
    fun write (name,file) = (Verbose.message ["Dumping ",name];
                             IniFile.write (name,file))

    val smlnj_version = "Standard ML of New Jersey "^version

    val project_ipr = 
    {sections = [
                 {name = "Language",
                  bindings = [
                              {name = "LanguageSupport0" , value = "0009"}
                              ]},
                 {name = "OperatingSystem",
                  bindings = [
                              {name = "OSSupport" , value = "0000000000011010"}
                              ]},
                 {name = "Data",
                  bindings = [
                              {name = "CurrentMedia" , value = ""},
                              {name = "set_mifserial" , value = ""},
                              {name = "ProductName" , value = smlnj_version},
                              {name = "CurrentComponentDef" , value = "Default.cdf"},
                              {name = "set_dlldebug" , value = "No"},
                              {name = "AppExe" , value = ""},
                              {name = "DevEnvironment" , value = "Microsoft Visual C++"},
                              {name = "set_mif" , value = "No"},
                              {name = "set_testmode" , value = "No"},
                              {name = "Instructions" , value = "Instructions.txt"},
                              {name = "EmailAddresss" , value = ""},
                              {name = "SummaryText" , value = ""},
                              {name = "Department" , value = ""},
                              {name = "Type" , value = "Software Development Application"},
                              {name = "Author" , value = ""},
                              {name = "HomeURL" , value = ""},
                              {name = "InstallRoot" , value = target},
                              {name = "set_level" , value = "Level 3"},
                              {name = "InstallationGUID" , value = "38d0bba9-86ec-11d1-8219-0060b01a0c8a"},
                              {name = "Version" , value = version},
                              {name = "set_miffile" , value = "Status.mif"},
                              {name = "set_args" , value = ""},
                              {name = "set_maxerr" , value = "50"},
                              {name = "Notes" , value = "Notes.txt"},
                              {name = "CurrentFileGroupDef" , value = "Default.fdf"},
                              {name = "set_dllcmdline" , value = ""},
                              {name = "set_warnaserr" , value = "No"},
                              {name = "Copyright" , value = ""},
                              {name = "set_preproc" , value = ""},
                              {name = "Category" , value = "Development Tool"},
                              {name = "CurrentPlatform" , value = ""},
                              {name = "set_crc" , value = "Yes"},
                              {name = "set_maxwarn" , value = "50"},
                              {name = "Description" , value = "Description.txt"},
                              {name = "CompanyName" , value = "Lucent Technologies"},
                              {name = "CurrentLanguage" , value = "English"}
                              ]},
                 {name = "MediaInfo",
                  bindings = [
                              {name = "mediadata0" , value = ""}
                              ]},
                 {name = "General",
                  bindings = [
                              {name = "PassData" , value = ""},
                              {name = "ReadOnly" , value = "N"},
                              {name = "Type" , value = "INSTALLMAIN"},
                              {name = "Version" , value = "2.20.000"},
                              {name = "PassOn" , value = "N"}
                              ]}
                 ]}
    
  val default_fgl = 
    {sections = [
                 {name = "General",
                  bindings = [
                              {name = "Type" , value = "FILELIST"},
                              {name = "Version" , value = "1.10.000"}
                              ]},
                 {name = "TopDir",
                  bindings = [
                              {name = "SubDir0" , value = "<WINDIR>"},
                              {name = "SubDir1" , value = "<PROGRAMFILES>"},
                              {name = "SubDir2" , value = "<TARGETDIR>"},
                              {name = "SubDir3" , value = "USERDEFINED"}
                              ]},
                 {name = "<WINDIR>",
                  bindings = [
                              {name = "fulldirectory" , value = ""},
                              {name = "SubDir0" , value = "<WINDIR>\\<WINSYSDIR>"},
                              {name = "DISPLAYTEXT" , value = "Windows Operating System"},
                              {name = "TYPE" , value = "TEXTSUBFIXED"}
                              ]},
                 {name = "<WINDIR>\\<WINSYSDIR>",
                  bindings = [
                              {name = "fulldirectory" , value = ""},
                              {name = "DISPLAYTEXT" , value = "Windows System Folder"},
                              {name = "TYPE" , value = "TEXTSUBFIXED"}
                              ]},
                 {name = "<PROGRAMFILES>",
                  bindings = [
                              {name = "fulldirectory" , value = ""},
                              {name = "SubDir0" , value = "<PROGRAMFILES>\\<COMMONFILES>"},
                              {name = "DISPLAYTEXT" , value = "Program Files Folder"},
                              {name = "TYPE" , value = "TEXTSUBFIXED"}
                              ]},
                 {name = "<PROGRAMFILES>\\<COMMONFILES>",
                  bindings = [
                              {name = "fulldirectory" , value = ""},
                              {name = "DISPLAYTEXT" , value = "Common Files Folder"},
                              {name = "TYPE" , value = "TEXTSUBFIXED"}
                              ]},
                 {name = "<TARGETDIR>",
                  bindings = [
                              {name = "fulldirectory" , value = ""},
                              {name = "DISPLAYTEXT" , value = "General Application Destination"},
                              {name = "TYPE" , value = "TEXTSUBFIXED"}
                              ]},
                 {name = "USERDEFINED",
                  bindings = [
                              {name = "fulldirectory" , value = ""},
                              {name = "DISPLAYTEXT" , value = "Script-defined Folders"},
                              {name = "TYPE" , value = "USERSTART"}
                              ]}
                 ]}

  val default_rge = 
    {sections = [
                 {name = "General",
                  bindings = [
                              {name = "Type" , value = "REGISTRYDATA"},
                              {name = "Version" , value = "2.10.000"}
                              ]}]}

  val so_default_shl = 
    {sections = [
                 {name = "Info",
                  bindings = [
                              {name = "Type" , value = "ShellObject"},
                              {name = "Version" , value = "2.10.000"}
                              ]},
                 {name = "Data",
                  bindings = [
                              {name = "Folder0" , value = "<FOLDER_DESKTOP>"},
                              {name = "Folder1" , value = "<FOLDER_STARTMENU>"},
                              {name = "Folder2" , value = "<FOLDER_PROGRAMS>"},
                              {name = "Folder3" , value = "<FOLDER_STARTUP>"},
                              {name = "Group0" , value = "Main"},
                              {name = "Group1" , value = "Startup"}]}
                ]}


  val default_shl = 
    {sections = [
                 {name = "TITLE_MAIN",
                  bindings = [
                              {name = "Comment" , value = ""}
                              ]},
                 {name = "COMPANY_NAME",
                  bindings = [
                              {name = "Comment" , value = ""}
                              ]},
                 {name = "COMPANY_NAME16",
                  bindings = [
                              {name = "Comment" , value = ""}
                              ]},
                 {name = "ERROR_MOVEDATA",
                  bindings = [
                              {name = "Comment" , value = ""}
                              ]},
                 {name = "PRODUCT_VERSION",
                  bindings = [
                              {name = "Comment" , value = ""}
                              ]},
                 {name = "UNINST_KEY",
                  bindings = [
                              {name = "Comment" , value = ""}
                              ]},
                 {name = "Language",
                  bindings = [
                              {name = "Lang0" , value = "0009"},
                              {name = "CurrentLang" , value = "0"}
                              ]},
                 {name = "TITLE_CAPTIONBAR",
                  bindings = [
                              {name = "Comment" , value = ""}
                              ]},
                 {name = "PRODUCT_NAME16",
                  bindings = [
                              {name = "Comment" , value = ""}
                              ]},
                 {name = "Data",
                  bindings = [
                              {name = "Entry0" , value = "ERROR_VGARESOLUTION"},
                              {name = "Entry1" , value = "TITLE_MAIN"},
                              {name = "Entry2" , value = "TITLE_CAPTIONBAR"},
                              {name = "Entry3" , value = "UNINST_KEY"},
                              {name = "Entry4" , value = "UNINST_DISPLAY_NAME"},
                              {name = "Entry5" , value = "COMPANY_NAME"},
                              {name = "Entry6" , value = "PRODUCT_NAME"},
                              {name = "Entry7" , value = "PRODUCT_VERSION"},
                              {name = "Entry8" , value = "PRODUCT_KEY"},
                              {name = "Entry10" , value = "ERROR_UNINSTSETUP"},
                              {name = "Entry9" , value = "ERROR_MOVEDATA"},
                              {name = "Entry11" , value = "COMPANY_NAME16"},
                              {name = "Entry12" , value = "PRODUCT_NAME16"},
                              {name = "Entry13" , value = "FOLDER_NAME"}
                              ]},
                 {name = "FOLDER_NAME",
                  bindings = [
                              {name = "Comment" , value = ""}
                              ]},
                 {name = "ERROR_VGARESOLUTION",
                  bindings = [
                              {name = "Comment" , value = ""}
                              ]},
                 {name = "PRODUCT_KEY",
                  bindings = [
                              {name = "Comment" , value = ""}
                              ]},
                 {name = "UNINST_DISPLAY_NAME",
                  bindings = [
                              {name = "Comment" , value = ""}
                              ]},
                 {name = "General",
                  bindings = [
                              {name = "Type" , value = "STRINGTABLE"},
                              {name = "Version" , value = "1.00.000"}
                              ]},
                 {name = "ERROR_UNINSTSETUP",
                  bindings = [
                              {name = "Comment" , value = ""}
                              ]},
                 {name = "PRODUCT_NAME",
                  bindings = [
                              {name = "Comment" , value = ""}
                              ]}
                 ]}


  val setup_tsb = 
    {sections = [
                 {name = "<HKCR>",
                  bindings = [
                              {name = "KeyType" , value = "4"},
                              {name = "Value" , value = ""}
                              ]},
                 {name = "<HKUS>",
                  bindings = [
                              {name = "KeyType" , value = "4"},
                              {name = "Value" , value = ""}
                              ]},
                 {name = "<SRCDIR>",
                  bindings = [
                              {name = "KeyType" , value = "4"},
                              {name = "Value" , value = ""}
                              ]},
                 {name = "<PROGRAMFILES>",
                  bindings = [
                              {name = "KeyType" , value = "4"},
                              {name = "Value" , value = ""}
                              ]},
                 {name = "<TARGETDIR>",
                  bindings = [
                              {name = "KeyType" , value = "4"},
                              {name = "Value" , value = ""}
                              ]},
                 {name = "<WINSYSDIR>",
                  bindings = [
                              {name = "KeyType" , value = "4"},
                              {name = "Value" , value = ""}
                              ]},
                 {name = "<COMMONFILES>",
                  bindings = [
                              {name = "KeyType" , value = "4"},
                              {name = "Value" , value = ""}
                              ]},
                 {name = "<WINDIR>",
                  bindings = [
                              {name = "KeyType" , value = "4"},
                              {name = "Value" , value = ""}
                              ]},
                 {name = "Data",
                  bindings = [
                              {name = "Key0" , value = "<PROGRAMFILES>"},
                              {name = "Key1" , value = "<COMMONFILES>"},
                              {name = "Key2" , value = "<WINDIR>"},
                              {name = "Key3" , value = "<WINSYSDIR>"},
                              {name = "Key4" , value = "<TARGETDIR>"},
                              {name = "Key10" , value = "<HKDD>"},
                              {name = "Key5" , value = "<SUPPORTDIR>"},
                              {name = "Key11" , value = "<HKUS>"},
                              {name = "Key6" , value = "<SRCDIR>"},
                              {name = "Key12" , value = "<HKCR>"},
                              {name = "Key7" , value = "<HKLM>"},
                              {name = "Key8" , value = "<HKCU>"},
                              {name = "Key9" , value = "<HKCC>"},
                              {name = "Key13" , value = "<SHELL_OBJECT_FOLDER>"},
                              {name = "Key14" , value = "<UNINST>"}
                              ]},
                 {name = "<SUPPORTDIR>",
                  bindings = [
                              {name = "KeyType" , value = "4"},
                              {name = "Value" , value = ""}
                              ]},
                 {name = "General",
                  bindings = [
                              {name = "Type" , value = "TEXTSUB"},
                              {name = "Version" , value = "1.10.000"}
                              ]},
                 {name = "<HKCU>",
                  bindings = [
                              {name = "KeyType" , value = "4"},
                              {name = "Value" , value = ""}
                              ]},
                 {name = "<HKLM>",
                  bindings = [
                              {name = "KeyType" , value = "4"},
                              {name = "Value" , value = ""}
                              ]},
                 {name = "<HKDD>",
                  bindings = [
                              {name = "KeyType" , value = "4"},
                              {name = "Value" , value = ""}
                              ]},
                 {name = "<HKCC>",
                  bindings = [
                              {name = "KeyType" , value = "4"},
                              {name = "Value" , value = ""}
                              ]},
                 {name = "<SHELL_OBJECT_FOLDER>",
                  bindings = [
                              {name = "KeyType" , value = "4"},
                              {name = "Value" , value = ""}
                              ]},
                 {name = "<UNINST>",
                  bindings = [
                              {name = "KeyType" , value = "4"},
                              {name = "Value" , value = ""}
                              ]}
                 ]}

  val build_tsb = 
    {sections = [
                 {name = "<PROGRAMFILES>",
                  bindings = [
                              {name = "Value" , value = ""},
                              {name = "KeyType" , value = "4"}
                              ]},
                 {name = "<WINSYSDIR>",
                  bindings = [
                              {name = "Value" , value = ""},
                              {name = "KeyType" , value = "4"}
                              ]},
                 {name = "<COMMONFILES>",
                  bindings = [
                              {name = "Value" , value = ""},
                              {name = "KeyType" , value = "4"}
                              ]},
                 {name = "<WINDIR>",
                  bindings = [
                              {name = "Value" , value = ""},
                              {name = "KeyType" , value = "4"}
                              ]},
                 {name = "Data",
                  bindings = [
                              {name = "Key0" , value = "<PROGRAMFILES>"},
                              {name = "Key1" , value = "<COMMONFILES>"},
                              {name = "Key2" , value = "<WINDIR>"},
                              {name = "Key3" , value = "<WINSYSDIR>"},
                              {name = "Key4" , value = "<ISPROJECTDIR>"}
                              ]},
                 {name = "<ISPROJECTDIR>",
                  bindings = [
                              {name = "Value" , value = ""},
                              {name = "KeyType" , value = "4"}
                              ]},
                 {name = "General",
                  bindings = [
                              {name = "Type" , value = "TEXTSUB"},
                              {name = "Version" , value = "1.20.000"}
                              ]}
                 ]}

(*
  val default_mda = 
    {sections = [
                 {name = "GeneralInfo",
                  bindings = [
                              {name = "Name" , value = "Default"},
                              {name = "MediaType" , value = "Single"},
                              {name = "BuildType" , value = "Full"},
                              {name = "BuildFolder" , value = concatP [target,"Media","Default"]},
                              {name = "Password" , value = ""},
                              {name = "BuildSize" , value = ""},
                              {name = "GUID" , value = ""}
                              ]},
                 {name = "SetupInfo",
                  bindings = [
                              {name = "EnableLangDlg" , value = "Yes"},
                              {name = "ApplicationName" , value = "Standard ML of New Jersey"}
                              ]},
                 {name = "Platforms",
                  bindings = [
                              {name = "key0" , value = "0000000000000010"},
                              {name = "key1" , value = "0000000000010000"}
                              ]},
                 {name = "Languages",
                  bindings = [
                              {name = "key0" , value = "0009"}
                              ]},
                 {name = "Filter",
                  bindings = [
                              {name = "LanguageDefault" , value = "0009"}
                              ]},
                 {name = "TagFileInfo",
                  bindings = [
                              {name = "ProductCategory" , value = "Development Tool"},
                              {name = "ApplicationName" , value = smlnj_version},
                              {name = "CompanyName" , value = "Lucent Technologies"},
                              {name = "Version" , value = version}
                              ]},
                 {name = "Internet",
                  bindings = [
                              {name = "WebPage" , value = "http://cm.bell-labs.com/cm/cs/what/smlnj/index.html"},
                              {name = "CreateDefaultWebPage" , value = "Yes"}
                              ]},
                 {name = "PostBuild",
                  bindings = [
                              {name = "FTPSite" , value = ""},
                              {name = "FTPFolder" , value = ""},
                              {name = "FTPUser" , value = ""},
                              {name = "FTPPassword" , value = ""},
                              {name = "Folder" , value = ""},
                              {name = "Batch File" , value = ""}
                              ]},
                 {name = "DataAsFilesComponents",
                  bindings = [
                              {name = "cml" , value = "No"},
                              {name = "compiler" , value = "No"},
                              {name = "ml-burg" , value = "No"},
                              {name = "ml-lex" , value = "No"},
                              {name = "ml-yacc" , value = "No"},
                              {name = "runtime" , value = "No"},
                              {name = "smlnj-lib" , value = "No"}
                              ]},
                 {name = "Package",
                  bindings = [
                              {name = "Create" , value = "Yes"},
                              {name = "Welcome" , value = "Yes"},
                              {name = "File" , value = "smlnj.exe"},
                              {name = "CommandLine" , value = ""},
                              {name = "ExtractFolder" , value = ""},
                              {name = "Password" , value = ""}
                              ]}
                 ]}
*)

  val value_shl = 
    {sections = [
                 {name = "Data",
                  bindings = [
                              {name = "TITLE_MAIN" , value = smlnj_version},
                              {name = "COMPANY_NAME" , value = "Lucent Technologies"},
                              {name = "COMPANY_NAME16" , value = "Lucent"},
                              {name = "ERROR_MOVEDATA" , value = "An error occurred during the move data process : %d"},
                              {name = "PRODUCT_VERSION" , value = version},
                              {name = "UNINST_KEY" , value = smlnj_version},
                              {name = "TITLE_CAPTIONBAR" , value = smlnj_version^" Setup"},
                              {name = "PRODUCT_NAME16" , value = "SMLNJ"},
                              {name = "FOLDER_NAME" , value = smlnj_version},
                              {name = "ERROR_VGARESOLUTION" , value = "This program requires VGA or better resolution."},
                              {name = "PRODUCT_KEY" , value = "dummy.exe"},
                              {name = "UNINST_DISPLAY_NAME" , value = smlnj_version},
                              {name = "ERROR_UNINSTSETUP" , value = "unInstaller setup failed to initialize.  You may not be able to uninstall this product."},
                              {name = "PRODUCT_NAME" , value = smlnj_version}
                              ]},
                 {name = "General",
                  bindings = [
                              {name = "Language" , value = "0009"},
                              {name = "Type" , value = "STRINGTABLESPECIFIC"},
                              {name = "Version" , value = "1.00.000"}
                              ]}
                 ]}


 in
    write (project_ipr_n,project_ipr);
    write (default_fgl_n,default_fgl);
    write (default_rge_n,default_rge);
    write (so_default_shl_n,so_default_shl);
    write (default_shl_n,default_shl);
    write (setup_tsb_n,setup_tsb);
    write (build_tsb_n,build_tsb);
(*    write (default_mda_n,default_mda); Media dir is magic in 6.2 *)
    write (value_shl_n,value_shl)
end (* dump *)
                    
end (* structure Basic *)
