#! /bin/ksh
# dummy.sh
# replace bin/*.bat and lib/*.cm files with dummy versions

#
# set the SML root directory
#
REAL_PWD=`pwd`
ROOT=${PWD:-$REAL_PWD}
case `uname -s` in 
  UWIN-NT)
    ROOT=`awk -F'/' '{printf ("%s:",$2) ; for (i=3; i<=NF; i++) printf ("/%s", $i)}' <<XXX
$ROOT
XXX`
  ;;
esac
echo ">>> SML root is $ROOT"

#
# set the various directory pathname variables
#
echo ">>> setting BINDIR, etc."
BINDIR=$ROOT/bin
LIBDIR=$ROOT/lib

# back up bin and lib files in bin.save, lib.save
mkdir $ROOT/bin.save
mkdir $ROOT/lib.save
cp $BINDIR/*.bat $ROOT/bin.save
cp $LIBDIR/*.cm $ROOT/lib.save

# create dummy batch files in bin directory
# (DBM: this should no longer be necessary, because the .bat files are
#  created in the build process above)
#
echo "Replacing bin .bat files with dummies."
for file in sml.bat sml-cm.bat ml-yacc.bat ml-lex.bat ml-burg.bat
do
    echo "@echo off" > $BINDIR/$file
    if [ ! -e $BINDIR/$file ]; then
	echo "!!! installation of $BINDIR/$file failed for some reason"
	exit 1
    fi
done

#
# create dummy library files in lib directory
# (commented out because the lib directory is populated with nondummy
# alias files when libraries are compiled above)
#
echo "Replacing lib alias files with dummies."
for file in smlnj-lib.cm pp-lib.cm html-lib.cm inet-lib.cm reactive-lib.cm regexp-lib.cm ml-yacc-lib.cm cml.cm cml-lib.cm
do
    echo "" > $LIBDIR/$file
    if [ ! -e $LIBDIR/$file ]; then
	echo "!!! installation of $LIBDIR/$file failed for some reason"
	exit 1
    fi
done
