#!/bin/sh
#
# Copyright (c) 1994 AT&T Bell Laboratories.
#
# installation script for SML/NJ and related tools; this is a temporary
# placeholder until the configuration tool is finished.
#

# This version (configwin/install.sh) has been modified to build under
# Windows (NT or 2000).  It builds a sml-cm.x86-win32 that needs to 
# have it's CM path reset to ["."] before InstallShield is used. See
# note in README-IS [dbm].

#set -x

#
# get the target list
#
echo ">>> checking for targets"
if [ ! -r configwin/targets ]; then
  echo "!!! no target list"
  exit 1;
fi
echo "executing targets"
. configwin/targets
echo ">>> TARGETS are $TARGETS"

#
# some OSs have make in strange places
#
echo ">>> setting MAKE"
MAKE=make

#
# command for building SML libraries; this should be either
# "CM.recompile()" or "CM.stabilize true".  The latter builds
# stable libraries, which may be somewhat faster to use.
#
#CM_MAKE_LIB="CM.recompile();"
CM_MAKE_LIB="CM.stabilize true;"

#
# check for ksh
#
echo ">>> defining SHELL: checking for ksh"
if [ -x /bin/ksh ]; then
  SHELL=/bin/ksh
elif [ -x /usr/local/bin/ksh ]; then
  SHELL=/usr/local/bin/ksh
elif [ -x "C:/Program Files/mks/mksnt/sh.exe" ]; then
  SHELL="C:/Program Files/mks/mksnt/sh.exe"
else
  SHELL=/bin/sh
fi
echo ">>> using $SHELL"

#
# set the SML root directory
#
REAL_PWD=`pwd`
ROOT=${PWD:-$REAL_PWD}
case `uname -s` in 
  UWIN-NT)
    ROOT=`awk -F'/' '{printf ("%s:",$2) ; for (i=3; i<=NF; i++) printf ("/%s", $i)}' <<XXX
$ROOT
XXX`
  ;;
esac
echo ">>> SML root is $ROOT"

#
# set the various directory pathname variables
#
echo ">>> setting BINDIR, etc."
BINDIR=$ROOT/bin
CONFIGDIR=$ROOT/configwin
HEAPDIR=$BINDIR/.heap
RUNDIR=$BINDIR/.run
SRCDIR=$ROOT/src
LIBDIR=$ROOT/lib
    
#
# the paths to ml-yacc,-lex,-burg 
# These were defined as below and used to configure CM, but we don't
# want to wire in the build BINDIR.  Instead, we let these default to
# "ml-yacc", "ml-lex", "ml-burg" (see src/cm/build).
# Under Windows we depend on the PATH variable being properly set to
# find the tool commands.
#
# YACCPATH=$BINDIR/ml-yacc
# LEXPATH=$BINDIR/ml-lex
# BURGPATH=$BINDIR/ml-burg

#
# the release version that we are installing
#
VERSION=`cat $CONFIGDIR/version`
echo ">>> installing version $VERSION"

#
# create the various sub directories
#
echo ">>> creating directories"
for dir in $BINDIR $HEAPDIR $RUNDIR $LIBDIR $SRCDIR
do
  if [ -d $dir ]; then
    echo ">>> $dir already exists"
  else
    echo ">>> creating $dir"
    mkdir $dir
    if [ $? != "0" ]; then
      echo "!!! unable to create $dir"
      exit 1
    fi
  fi
done
echo ">>> directories created"

#
# install the script that tests the architecture, and make sure that it works
#
echo ">>> installing .arch-n-opsys"
if [ -x $BINDIR/.arch-n-opsys ]; then
  echo ">>> $BINDIR/.arch-n-opsys already exists"
else
  cat $CONFIGDIR/_arch-n-opsys | sed -e "s,@SHELL@,$SHELL,g" > $BINDIR/.arch-n-opsys
  chmod 555 $BINDIR/.arch-n-opsys
  if [ ! -x $BINDIR/.arch-n-opsys ]; then
    echo "!!! installation of $BINDIR/.arch-n-opsys failed for some reason"
    exit 1
  fi
fi
ARCH_N_OPSYS=`$BINDIR/.arch-n-opsys`
if [ "$?" != "0" ]; then
  echo "!!! $BINDIR/.arch-n-opsys fails on this machine"
  echo "!!! you must patch this by hand and repeat the installation"
  exit 2
else
  echo "$BINDIR/.arch-n-opsys reports $ARCH_N_OPSYS"
fi
eval $ARCH_N_OPSYS

#
# define Windows variant of ROOT
#
case $OPSYS in
  win32)
    ROOT_WIN=`sh configwin/convert.sh $ROOT`
    echo ">>> ROOT_WIN is $ROOT_WIN"
  ;;
esac

#
# install .run-sml script (for unix -- not used in Windows)
#
case $OPSYS in
  win32)
    echo ">>> .run-sml not installed in Windows (MKS issue)"
  ;;
  *)
    if [ -x $BINDIR/.run-sml ]; then
      echo ">>> $BINDIR/.run-sml already exists"
    else
      echo ">>> installing .run-sml"
      cat $CONFIGDIR/_run-sml | \
	sed -e "s,@SHELL@,$SHELL,g" -e "s,@BINDIR@,$BINDIR," -e "s,@VERSION@,$VERSION," \
	> $BINDIR/.run-sml
      chmod 555 $BINDIR/.run-sml
      if [ ! -x $BINDIR/.run-sml ]; then
	echo "!!! installation of $BINDIR/.run-sml failed for some reason"
	exit 1
      fi
    fi
  ;;
esac

#
# set some architecture dependent run-time system flags
#
echo ">>> setting ALLOC"
case $ARCH in
  mips*) ALLOC=1M ;;
  x86)
    ALLOC=256k
  ;;
  alpha32)
    ALLOC=512k
  ;;
  *)
    ALLOC=512k
  ;;
esac
echo ">>> ALLOC set to $ALLOC"
case $OPSYS in
  solaris)
    echo ">>> solaris: setting MAKE"
    MAKE=/usr/ccs/bin/make
  ;;
  linux)
    echo "linux: setting EXTRA_DEFS"
    EXTRA_DEFS=`$CONFIGDIR/chk-global-names.sh`
    if [ "$?" != "0" ]; then
      echo "!!! problems checking for underscores in global names"
      exit 1
    fi
    EXTRA_DEFS="XDEFS=$EXTRA_DEFS"
    echo ">>> linux: EXTRA_DEFS set to $EXTRA_DEFS"
  ;;
esac

#
# UWIN under Win32 seems to mess up symbolic links, so we just
# copy
#
echo ">>> setting LN"
case $OPSYS in
  win32) 
    LN=cp
  ;;
  *)
    LN="ln -s"
  ;;
esac
echo ">>> LN set to $LN"

#
# setting the name of the bin files directory
#
echo ">>> setting BIN_FILES"
BIN_FILES=bin.$ARCH-$OPSYS
echo ">>> BIN_FILES set to $BIN_FILES"

#
# setting the name of the runtime executable
#
echo ">>> setting RUN"
case $OPSYS in
  win32)
    RUN=run.$ARCH-$OPSYS.exe
  ;;
  *)
    RUN=run.$ARCH-$OPSYS
  ;;
esac
echo ">>> RUN set to $RUN"

#
# build the run-time system
#
echo ">>> unpacking runtime"
sh $CONFIGDIR/unpack.sh "run-time" $SRCDIR runtime $ROOT/runtime.tar
if [ ! -r $SRCDIR/runtime/objs/build-win32.bat ]; then
  echo ">>> copying build-win32.bat"
  cp $CONFIGDIR/win32/build-win32.bat $SRCDIR/runtime/objs
else 
  echo ">>> build-win32.bat already exists"
fi  
if [ "$?" != "0" ]; then
  exit $?
fi

if [ ! -x $RUNDIR/$RUN ]; then
  cd $SRCDIR/runtime/objs
  echo ">>> compiling the run-time system"
  case $OPSYS in
    win32) 
      cmd /c "build-win32"
      if [ -x $RUN ]; then
        mv $RUN $RUNDIR
      else
        echo "!!! run-time system build failed for some reason"
        exit 1
      fi
    ;;
    *)
      $MAKE -f mk.$ARCH-$OPSYS $EXTRA_DEFS
      if [ -x $RUN ]; then
        mv $RUN $RUNDIR
        $MAKE MAKE=$MAKE clean
      else
        echo "!!! run-time system build failed for some reason"
        exit 1
      fi
    ;;
  esac
fi
cd $SRCDIR

#
# boot the base SML system, creating sml heap image
#
if [ -r $HEAPDIR/sml.$HEAP_SUFFIX ]; then
  echo ">>> $HEAPDIR/sml.$HEAP_SUFFIX already exists"
else
  if [ ! -d $ROOT/$BIN_FILES ]; then
    if [ -r $ROOT/$BIN_FILES.tar.Z ]; then
      cd $ROOT
      echo ">>> unpacking bin files"
      zcat $BIN_FILES.tar.Z | tar -xf -
    elif [ -r $ROOT/$BIN_FILES.tar ]; then
      cd $ROOT
      echo ">>> unpacking bin files"
      tar -xf $BIN_FILES.tar
    else
      echo "!!! the bin files are missing"
      exit 1
    fi
    if [ ! -d $ROOT/$BIN_FILES ]; then
      echo "!!! unable to unpack bin files"
      exit 1
    fi
  fi
  cd $ROOT
  echo ">>> creating sml heap image"
#  $RUNDIR/$RUN @SMLboot=$ROOT/$BIN_FILES @SMLalloc=$ALLOC <<XXXX
  $RUNDIR/$RUN @SMLboot=$BIN_FILES @SMLalloc=$ALLOC <<XXXX
    $SET_FLAGS
    val use = Compiler.Interact.useFile
    val _ = (SMLofNJ.exportML "sml";
             print Compiler.banner;
             print "\n");
XXXX
  if [ -r sml.$HEAP_SUFFIX ]; then
    echo ">>> moving sml heap image to bin/.heap"
    mv sml.$HEAP_SUFFIX $HEAPDIR
    case $OPSYS in
      win32)
        echo ">>> win32: creating bin/sml.bat"
	cat $CONFIGDIR/win32/_sml.bat | \
	  sed -e "s,@ROOT@,$ROOT_WIN,g" \
	  > $BINDIR/sml.bat
      ;;
      *)
        echo ">>> unix: linking bin/sml"
        cd $BINDIR
        $LN .run-sml sml
      ;;
    esac
  else
    echo "!!! unable to build SML heap image (sml.$HEAP_SUFFIX)"
    exit 1
  fi
fi

#
# now build the individual targets
#
cd $SRCDIR
echo ">>> install targets"
for i in $TARGETS
do
  if [ $i = "doc" ]; then
    TARGET=$i
  else
    TARGET=$i.$HEAP_SUFFIX
  fi
  if [ -r $HEAPDIR/$TARGET ]; then
    echo ">>> $TARGET already exists"
  else
    echo ">>> building $i"
    case $i in
      src-smlnj)
	sh $CONFIGDIR/unpack.sh src-smlnj $ROOT/src sml-nj $ROOT/sml-nj.tar
      ;;
      sml-full)
	if [ ! -d $ROOT/$BIN_FILES ]; then
	  echo "!!! bin files are missing; build of $TARGET failed"
	  exit 1
	else
	  cd $ROOT
	  $RUNDIR/$RUN @SMLfull @SMLboot=$ROOT/$BIN_FILES @SMLalloc=$ALLOC <<XXXX
	    $SET_FLAGS
	    val use = Compiler.Interact.useFile
	    val _ = (SMLofNJ.exportML "sml-full";
		     print Compiler.banner;
		     print " [full]\n");
XXXX
	  if [ -r $TARGET ]; then
	    mv $TARGET $HEAPDIR
	    case $OPSYS in
	      win32)
		echo ">>> win32: creating bin/$i.bat"
		cat $CONFIGDIR/win32/_$i.bat | \
		  sed -e "s,@ROOT@,$ROOT_WIN,g" \
		  > $BINDIR/$i.bat
	      ;;
	      *)
		echo ">>> unix: linking bin/$i"
		cd $BINDIR
		$LN .run-sml $i
	      ;;
	    esac
	  else
	    echo "!!! unable to build SML-FULL heap image"
	    exit 1
	  fi
	fi
      ;;
      sml-cm)
	sh $CONFIGDIR/unpack.sh CM $SRCDIR cm $ROOT/cm.tar
        if [ "$?" != "0" ]; then
	  echo "!!! failed to unpack cm.tar.Z"
	  exit $?
        fi
        cd $SRCDIR/cm
	sh ./build -L "."
        if [ -r $TARGET ]; then
	  mv $TARGET $HEAPDIR
	  case $OPSYS in
	    win32)
   	      if [ ! -f $BINDIR/$i.bat ]; then
		echo ">>> win32: creating bin/$i.bat"
		cat $CONFIGDIR/win32/_$i.bat | \
		  sed -e "s,@ROOT@,$ROOT_WIN,g" \
		  > $BINDIR/$i.bat
	      else
	        echo ">>> win32: bin/$i.bat already exists"
	      fi
	    ;;
	    *)
   	      if [ ! -f $BINDIR/$i ]; then
	        echo ">>> unix: linking bin/$i"
	        cd $BINDIR
	        $LN .run-sml $i
	      else
	        echo ">>> unix: bin/$i already exists"
	      fi
	    ;;
	  esac
        else
	  echo "!!! build of $TARGET failed"
	  exit 1
        fi
	if [ "$INSTALL_SML_AND_CM" != "TRUE" ]; then
	  cd $HEAPDIR
	  rm -f sml.$HEAP_SUFFIX
          $LN sml-cm.$HEAP_SUFFIX sml.$HEAP_SUFFIX
	fi
      ;;
      sml-full-cm)
	sh $CONFIGDIR/unpack.sh CM $SRCDIR cm $ROOT/cm.tar
        if [ "$?" != "0" ]; then
	  exit $?
        fi
        cd $SRCDIR/cm
	sh ./build -L ".:$LIBDIR" -sml $BINDIR/sml-full -o $TARGET
        if [ -r $TARGET ]; then
	  mv $TARGET $HEAPDIR
	  case $OPSYS in
	    win32)
   	      if [ ! -f $BINDIR/$i.bat ]; then
		echo ">>> win32: creating bin/$i.bat"
		cat $CONFIGDIR/win32/_$i.bat | \
		  sed -e "s,@ROOT@,$ROOT_WIN,g" \
		  > $BINDIR/$i.bat
	      else
	        echo ">>> win32: bin/$i.bat already exists"
	      fi
	    ;;
	    *)
   	      if [ ! -f $BINDIR/$i ]; then
	        echo ">>> unix: linking bin/$i"
	        cd $BINDIR
	        $LN .run-sml $i
	      else
	        echo ">>> unix: bin/$i already exists"
	      fi
	    ;;
	  esac
        else
	  echo "!!! build of $TARGET failed"
	  exit 1
        fi
      ;;
      ml-yacc)
        sh $CONFIGDIR/unpack.sh ML-Yacc $SRCDIR ml-yacc $ROOT/ml-yacc.tar
        if [ "$?" != "0" ]; then
	  exit $?
        fi
        cd $SRCDIR/ml-yacc
        sh ./build
        if [ -r src/$TARGET ]; then
	  mv src/$TARGET $HEAPDIR
	  case $OPSYS in
	    win32)
   	      if [ ! -f $BINDIR/$i.bat ]; then
		echo ">>> win32: creating bin/$i.bat"
		cat $CONFIGDIR/win32/_$i.bat | \
		  sed -e "s,@ROOT@,$ROOT_WIN,g" \
		  > $BINDIR/$i.bat
	      else
	        echo ">>> win32: bin/$i.bat already exists"
	      fi
	    ;;
	    *)
   	      if [ ! -f $BINDIR/$i ]; then
	        echo ">>> unix: linking bin/$i"
	        cd $BINDIR
	        $LN .run-sml $i
	      else
	        echo ">>> unix: bin/$i already exists"
	      fi
	    ;;
	  esac
        else
	  echo "!!! build of $TARGET failed"
	  exit 1
        fi
      ;;
      ml-lex)
        sh $CONFIGDIR/unpack.sh ML-Lex $SRCDIR ml-lex $ROOT/ml-lex.tar
        if [ "$?" != "0" ]; then
	  exit $?
        fi
        cd $SRCDIR/ml-lex
        sh ./build
        if [ -r $TARGET ]; then
	  mv $TARGET $HEAPDIR
	  case $OPSYS in
	    win32)
   	      if [ ! -f $BINDIR/$i.bat ]; then
		echo ">>> win32: creating bin/$i.bat"
		cat $CONFIGDIR/win32/_$i.bat | \
		  sed -e "s,@ROOT@,$ROOT_WIN,g" \
		  > $BINDIR/$i.bat
	      else
	        echo ">>> win32: bin/$i.bat already exists"
	      fi
	    ;;
	    *)
   	      if [ ! -f $BINDIR/$i ]; then
	        echo ">>> unix: linking bin/$i"
	        cd $BINDIR
	        $LN .run-sml $i
	      else
	        echo ">>> unix: bin/$i already exists"
	      fi
	    ;;
	  esac
        else
	  echo "!!! build of $TARGET failed"
	  exit 1
        fi
      ;;
      ml-burg)
        sh $CONFIGDIR/unpack.sh ML-Burg $SRCDIR ml-burg $ROOT/ml-burg.tar
        if [ "$?" != "0" ]; then
	  echo "!!! unpacking ${VERSION}-ml-burg.tar.Z failed"
	  exit $?
        fi
        cd $SRCDIR/ml-burg
        sh ./build
        if [ -r $TARGET ]; then
	  mv $TARGET $HEAPDIR
	  case $OPSYS in
	    win32)
   	      if [ ! -f $BINDIR/$i.bat ]; then
		echo ">>> win32: creating bin/$i.bat"
		cat $CONFIGDIR/win32/_$i.bat | \
		  sed -e "s,@ROOT@,$ROOT_WIN,g" \
		  > $BINDIR/$i.bat
	      else
	        echo ">>> win32: bin/$i.bat already exists"
	      fi
	    ;;
	    *)
   	      if [ ! -f $BINDIR/$i ]; then
	        echo ">>> unix: linking bin/$i"
	        cd $BINDIR
	        $LN .run-sml $i
	      else
	        echo ">>> unix: bin/$i already exists"
	      fi
	    ;;
	  esac
        else
	  echo "!!! build of $TARGET failed"
	  exit 1
        fi
      ;;
      smlnj-lib)
        echo ">>> unpacking ${Version}-smlnj-lib.tar.Z"
        sh $CONFIGDIR/unpack.sh "SML/NJ Library" $SRCDIR smlnj-lib $ROOT/smlnj-lib.tar
        if [ "$?" != "0" ]; then
	  echo ">>> unpacking smlnj-lib failed"
	  exit $?
        fi
      # make the Util library
	echo ">>> compiling Util library"
        cd $SRCDIR/smlnj-lib/Util
	echo "CM.stabilize'(\"smlnj-lib.cm\", true);" | $BINDIR/sml-cm
	if [ ! -f $LIBDIR/smlnj-lib.cm ]; then
          cd $LIBDIR
	  case $OPSYS in
	    win32)
	      echo "Alias \"$ROOT_WIN\\src\\smlnj-lib\\Util\\smlnj-lib.cm\"" \
              > smlnj-lib.cm
	    ;;
	    *)
              echo "Alias $SRCDIR/smlnj-lib/Util/smlnj-lib.cm" > smlnj-lib.cm
	    ;;
	  esac
	fi
      # make the Unix library
        case $OPSYS in
	  win32) 
	    echo ">>> cannot build Unix library under Windows"
	  ;;
	  *)
	    echo ">>> compiling Unix library"
	    cd $SRCDIR/smlnj-lib/Unix
	    echo "CM.stabilize'(\"unix-lib.cm\", true);" | $BINDIR/sml-cm
	    if [ ! -f $LIBDIR/unix-lib.cm ]; then
	      cd $LIBDIR
	      echo "Alias $SRCDIR/smlnj-lib/Unix/unix-lib.cm" > unix-lib.cm
	    fi
          ;;
	esac
      # make the INet library
	echo ">>> compiling INet library"
        cd $SRCDIR/smlnj-lib/INet
	echo "CM.stabilize'(\"inet-lib.cm\", true);" | $BINDIR/sml-cm
	if [ ! -f $LIBDIR/inet-lib.cm ]; then
          cd $LIBDIR
	  case $OPSYS in
	    win32)
	      echo "Alias \"$ROOT_WIN\\src\\smlnj-lib\\INet\\inet-lib.cm\"" \
              > inet-lib.cm
	    ;;
	    *)
              echo "Alias $SRCDIR/smlnj-lib/INet/inet-lib.cm" > inet-lib.cm
	    ;;
	  esac
	fi
      # make the HTML library
	echo ">>> compiling HTML library"
        cd $SRCDIR/smlnj-lib/HTML
	echo "CM.stabilize'(\"html-lib.cm\", true);" | $BINDIR/sml-cm
	if [ ! -f $LIBDIR/html-lib.cm ]; then
          cd $LIBDIR
	  case $OPSYS in
	    win32)
	      echo "Alias \"$ROOT_WIN\\src\\smlnj-lib\\HTML\\html-lib.cm\"" \
              > html-lib.cm
	    ;;
	    *)
              echo "Alias $SRCDIR/smlnj-lib/HTML/html-lib.cm" > html-lib.cm
	    ;;
	  esac
	fi
      # make the PP library
	echo ">>> compiling PP library"
        cd $SRCDIR/smlnj-lib/PP
	echo "CM.stabilize'(\"pp-lib.cm\", true);" | $BINDIR/sml-cm
	if [ ! -f $LIBDIR/pp-lib.cm ]; then
          cd $LIBDIR
	  case $OPSYS in
	    win32)
	      echo "Alias \"$ROOT_WIN\\src\\smlnj-lib\\PP\\pp-lib.cm\"" \
              > pp-lib.cm
	    ;;
	    *)
              echo "Alias $SRCDIR/smlnj-lib/PP/pp-lib.cm" > pp-lib.cm
	    ;;
	  esac
	fi
      # make the RegExp library
	echo ">>> compiling RegExp library"
        cd $SRCDIR/smlnj-lib/RegExp
	echo "CM.stabilize'(\"regexp-lib.cm\", true);" | $BINDIR/sml-cm
	if [ ! -f $LIBDIR/regexp-lib.cm ]; then
          cd $LIBDIR
	  case $OPSYS in
	    win32)
	      echo "Alias \"$ROOT_WIN\\src\\smlnj-lib\\RegExp\\\\regexp-lib.cm\"" \
              > regexp-lib.cm
	    ;;
	    *)
              echo "Alias $SRCDIR/smlnj-lib/RegExp/regexp-lib.cm" > regexp-lib.cm
	    ;;
	  esac
	fi
      # make the Reactive library
	echo ">>> compiling Reactive library"
        cd $SRCDIR/smlnj-lib/Reactive
	echo "CM.stabilize'(\"reactive-lib.cm\", true);" | $BINDIR/sml-cm
	if [ ! -f $LIBDIR/reactive-lib.cm ]; then
          cd $LIBDIR
	  case $OPSYS in
	    win32)
	      echo "Alias \"$ROOT_WIN\\src\\smlnj-lib\\Reactive\\\\reactive-lib.cm\"" \
              > reactive-lib.cm
	    ;;
	    *)
              echo "Alias $SRCDIR/smlnj-lib/Reactive/reactive-lib.cm" > reactive-lib.cm
	    ;;
	  esac
	fi
      ;;
      ml-yacc-lib)
        sh $CONFIGDIR/unpack.sh ML-Yacc $SRCDIR ml-yacc $ROOT/ml-yacc.tar
        if [ "$?" != "0" ]; then
	  echo "!!! unpacking ml-yacc failed; exiting"
	  exit $?
        fi
	echo ">>> compiling ml-yacc/lib library"
        cd $SRCDIR/ml-yacc/lib
        echo "$CM_MAKE_LIB" | $BINDIR/sml-cm
	if [ ! -f $LIBDIR/ml-yacc-lib.cm ]; then
          cd $LIBDIR
	  case $OPSYS in
	    win32)
	      echo "Alias \"$ROOT_WIN\\src\\ml-yacc\\lib\\sources.cm\"" \
              > ml-yacc-lib.cm
	    ;;
	    *)
              echo "Alias $SRCDIR/ml-yacc/lib/sources.cm" > ml-yacc-lib.cm
	    ;;
	  esac
	fi
      ;;
      cml)
        sh $CONFIGDIR/unpack.sh CML $SRCDIR cml $ROOT/cml.tar
        if [ "$?" != "0" ]; then
	  echo "!!! unpacking cml failed; exiting"
	  exit $?
        fi
	echo ">>> compiling cml"
        cd $SRCDIR/cml/src
        echo "$CM_MAKE_LIB" | $BINDIR/sml-cm
	if [ ! -f $LIBDIR/cml.cm ]; then
          cd $LIBDIR
	  case $OPSYS in
	    win32)
	      echo "Alias \"$ROOT_WIN\\src\\\\cml\\src\\sources.cm\"" \
              > cml.cm
	    ;;
	    *)
              echo "Alias $SRCDIR/cml/src/sources.cm" > cml.cm
	    ;;
	  esac
	fi
      ;;
      cml-lib)
	sh $CONFIGDIR/unpack.sh CML $SRCDIR cml $ROOT/cml.tar
	if [ "$?" != "0" ]; then
	  echo "!!! unpacking cml-lib failed; exiting"
	  exit $?
	fi
	echo ">>> compiling cml-lib"
	cd $SRCDIR/cml/cml-lib
	echo "$CM_MAKE_LIB" | $BINDIR/sml-cm
	if [ ! -f $LIBDIR/cml-lib.cm ]; then
	  cd $LIBDIR
	  case $OPSYS in
	    win32)
	      echo "Alias \"$ROOT_WIN\\src\\cml\\\\cml-lib\\sources.cm\"" \
              > cml-lib.cm
	    ;;
	    *)
	      echo "Alias $SRCDIR/cml/cml-lib/sources.cm" > cml-lib.cm
	    ;;
	  esac
	fi
      ;;
# NOTE: cml-cm doesn't really work right now because of CM features (bugs).
      cml-cm)
	CMD="CM.autoloading(SOME true); CM.clearAutoList();"
	CMD="$CMD CM.autoload'(\"$LIBDIR/cml.cm\");"
	if [ "$AUTOLOAD_CML_LIB" = "TRUE" ]; then
	  CMD="$CMD CM.autoload'(\"$LIBDIR/cml-lib.cm\");"
	fi
	if [ "$AUTOLOAD_EXENE" = "TRUE" ]; then
	  CMD="$CMD CM.autoload'(\"$LIBDIR/eXene.cm\");"
	fi
	cd $ROOT
	$BINDIR/sml-cm <<XXXX
	  $CMD
	  val _ = (SMLofNJ.exportML "$i";
		print CML.banner;
		print "[CML autoload]\n");
XXXX
	if [ -r $TARGET ]; then
	  mv $TARGET $HEAPDIR
	  case $OPSYS in
	    win32)
   	      if [ ! -f $BINDIR/$i.bat ]; then
		echo ">>> win32: creating bin/$i.bat"
		cat $CONFIGDIR/_$i.bat | \
		  sed -e "s,@ROOT@,$ROOT_WIN,g" \
		  > $BINDIR/$i.bat
	      else
	        echo ">>> win32: bin/$i.bat already exists"
	      fi
	    ;;
	    *)
   	      if [ ! -f $BINDIR/$i ]; then
	        echo ">>> unix: linking bin/$i"
	        cd $BINDIR
	        $LN .run-sml $i
	      else
	        echo ">>> unix: bin/$i already exists"
	      fi
	    ;;
	  esac
	else
	  echo "!!! unable to build autoloading CML"
	  exit 1
	fi
      ;;
      eXene)
        case $OPSYS in
          win32)
            echo ">>> cannot install eXene for win32 systems"
          ;;
          *)
            $CONFIGDIR/unpack.sh EXene $SRCDIR eXene $ROOT/eXene.tar
            if [ "$?" != "0" ]; then
        	  exit $?
            fi
            cd $SRCDIR/eXene
            echo "$CM_MAKE_LIB" | $BINDIR/sml-cm
    	    if [ ! -f $LIBDIR/eXene.cm ]; then
              cd $LIBDIR
              echo "Alias $SRCDIR/eXene/sources.cm" > eXene.cm
    	    fi
          ;;
        esac
      ;;
      doc)
	sh $CONFIGDIR/unpack.sh Doc $ROOT doc $ROOT/doc.tar
        if [ "$?" != "0" ]; then
	  echo "!!! unpacking doc failed"
	  exit $?
        fi
        cd $ROOT/doc
	build $ROOT
      ;;
      *)
        echo "!!! unknown target $i"
      ;;
    esac
  fi
done

case $OPSYS in
  win32)
    echo ">>> Skipping autoloading - it dies for some unknown reason."
  ;;
  *)
if [ "$ENABLE_AUTOLOADING" = "TRUE" ]; then
  CMD="CM.autoloading(SOME true); CM.clearAutoList();"
  if [ "$AUTOLOAD_SMLNJ_LIB" = "TRUE" ]; then
    CMD="$CMD CM.autoload'(\"$LIBDIR/smlnj-lib.cm\");"
  fi
  if [ "$AUTOLOAD_SMLNJ_UNIX" = "TRUE" ]; then
    CMD="$CMD CM.autoload'(\"$LIBDIR/unix-lib.cm\");"
  fi
  if [ "$AUTOLOAD_SMLNJ_INET" = "TRUE" ]; then
    CMD="$CMD CM.autoload'(\"$LIBDIR/inet-lib.cm\");"
  fi
  if [ "$AUTOLOAD_SMLNJ_HTML" = "TRUE" ]; then
    CMD="$CMD CM.autoload'(\"$LIBDIR/html-lib.cm\");"
  fi
  if [ "AUTOLOAD_SMLNJ_PP" = "TRUE" ]; then
    CMD="$CMD CM.autoload'(\"$LIBDIR/pp-lib.cm\");"
  fi
  if [ "AUTOLOAD_SMLNJ_REGEXP" = "TRUE" ]; then
    CMD="$CMD CM.autoload'(\"$LIBDIR/regexp-lib.cm\");"
  fi
  if [ "$AUTOLOAD_SMLNJ_REACTIVE" = "TRUE" ]; then
    CMD="$CMD CM.autoload'(\"$LIBDIR/reactive-lib.cm\");"
  fi
  cd $ROOT
  $BINDIR/sml-cm <<XXXX
    $CMD
    val _ = (SMLofNJ.exportML "sml-cm";
             print Compiler.banner;
             print " [CM; autoload enabled]\n");
XXXX
  if [ -r sml-cm.$HEAP_SUFFIX ]; then
    mv sml-cm.$HEAP_SUFFIX $HEAPDIR
  else
    echo "!!! unable to build SML with autoloading"
    exit 1
  fi
fi
;;
esac


#
# only continue if we're doing a win32 install
#
case $OPSYS in
  win32) 
    echo ">>> Customized installation process for InstallShield5.0"
  ;;
  *)
    exit 0
  ;;
esac




######################################################################
# 
# this part of the script takes the win32 installation built above 
# and throws in the few remaining pieces (icon, readme), 
# creates the dummy batch files, and finally generates the description 
# directory for IS-GEN.
#

WIN32CONFIGDIR=$CONFIGDIR/win32
FULLVERSION=`cat $WIN32CONFIGDIR/fullversion`

#
# First, create the 'support' directory and copy icon and other files
#
SUPPORTDIR=$ROOT/support
if [ -d $SUPPORTDIR ]; then
    echo ">>> $SUPPORTDIR already exists"
else
    echo ">>> creating $SUPPORTDIR"
    mkdir $SUPPORTDIR
    if [ $? != "0" ]; then
        echo "!!! unable to create $SUPPORTDIR"
        exit 1
    fi
fi
for file in smlnj.ico readme.html documentation.html license.txt
do
  if [ -e $SUPPORTDIR/$file ]; then
      echo ">>> $SUPPORTDIR/$file already exists"
  else
      cp $WIN32CONFIGDIR/$file $SUPPORTDIR/$file
      if [ ! -e $SUPPORTDIR/$file ]; then
          echo "!!! installation of $SUPPORTDIR/$file failed for some reason"
          exit 1
      fi
  fi
done


#
# create the version directory for the IS-GEN description files
#
VERSIONDIR=$WIN32CONFIGDIR/$FULLVERSION
if [ -d $VERSIONDIR ]; then
    echo ">>> $VERSIONDIR already exists"
else
    echo ">>> creating $VERSIONDIR"
    mkdir $VERSIONDIR
    if [ $? != "0" ]; then
        echo "!!! unable to create $VERSIONDIR"
        exit 1
    fi
fi

#
# copy setup.rul and license.txt
#
for file in setup.rul license.txt
do
    if [ -e $VERSIONDIR/$file ]; then
        echo ">>> $VERSIONDIR/$file already exists"
    else
        cp $WIN32CONFIGDIR/$file $VERSIONDIR/$file
        if [ ! -e $VERSIONDIR/$file ]; then
            echo "!!! installation of $VERSIONDIR/$file failed for some reason"
            exit 1
        fi
    fi
done

#
# create component files
#
# DBM: what about cml-lib?
cd $ROOT
for component in compiler cml ml-burg ml-lex ml-yacc runtime support smlnj-lib
do
    if [ -e $VERSIONDIR/$component ]; then
        echo ">>> $VERSIONDIR/$component already exists"
    else
        case $component in
            compiler) 
                echo "This component includes the heap image of the compiler (including CM)." > $VERSIONDIR/$component
                echo "Copying compiler files." >> $VERSIONDIR/$component
                echo "bin/.heap/sml.x86-win32" >> $VERSIONDIR/$component
                echo "bin/sml.bat" >> $VERSIONDIR/$component
                echo "bin/sml-cm.bat" >> $VERSIONDIR/$component
            ;;
            cml)
                echo "This component includes the Concurrent ML system and libraries." > $VERSIONDIR/$component
                echo "Copying Concurrent ML files." >> $VERSIONDIR/$component
                echo "lib/cml.cm" >> $VERSIONDIR/$component
                echo "lib/cml-lib.cm" >> $VERSIONDIR/$component
                find src/cml -type f -print >> $VERSIONDIR/$component
            ;;
            ml-burg)
                echo "This component includes the ml-burg tool." > $VERSIONDIR/$component
                echo "Copying ml-burg files." >> $VERSIONDIR/$component
                echo "bin/.heap/ml-burg.x86-win32" >> $VERSIONDIR/$component
                echo "bin/ml-burg.bat" >> $VERSIONDIR/$component
            ;;
            ml-lex)
                echo "This component includes the ml-lex lexer generator tool." > $VERSIONDIR/$component
                echo "Copying ml-lex files." >> $VERSIONDIR/$component
                echo "bin/.heap/ml-lex.x86-win32" >> $VERSIONDIR/$component
                echo "bin/ml-lex.bat" >> $VERSIONDIR/$component
            ;;
            ml-yacc)
                echo "This component includes the ml-yacc parser generator tool." > $VERSIONDIR/$component
                echo "Copying ml-yacc files." >> $VERSIONDIR/$component
                echo "bin/.heap/ml-yacc.x86-win32" >> $VERSIONDIR/$component
                echo "bin/ml-yacc.bat" >> $VERSIONDIR/$component
                echo "lib/ml-yacc-lib.cm" >> $VERSIONDIR/$component
                find src/ml-yacc/lib -type f -print >> $VERSIONDIR/$component
            ;;
            runtime)
                echo "This component includes the runtime system." > $VERSIONDIR/$component
                echo "Copying runtime system." >> $VERSIONDIR/$component
                echo "bin/.run/run.x86-win32.exe" >> $VERSIONDIR/$component
            ;;
            support)
                echo "This component includes the support files." > $VERSIONDIR/$component
                echo "Copying support system files." >> $VERSIONDIR/$component
                echo "support/smlnj.ico" >> $VERSIONDIR/$component
                echo "support/readme.html" >> $VERSIONDIR/$component
                echo "support/documentation.html" >> $VERSIONDIR/$component
                echo "support/license.txt" >> $VERSIONDIR/$component
            ;;
            smlnj-lib)
                echo "This component includes the Standard ML of New Jersey library." > $VERSIONDIR/$component
                echo "Copying Standard ML of New Jersey library files." >> $VERSIONDIR/$component
                echo "lib/html-lib.cm" >> $VERSIONDIR/$component
                echo "lib/inet-lib.cm" >> $VERSIONDIR/$component
                echo "lib/pp-lib.cm" >> $VERSIONDIR/$component
                echo "lib/reactive-lib.cm" >> $VERSIONDIR/$component
                echo "lib/regexp-lib.cm" >> $VERSIONDIR/$component
                echo "lib/smlnj-lib.cm" >> $VERSIONDIR/$component
                #echo "lib/unix-lib.cm" >> $VERSIONDIR/$component
                find src/smlnj-lib -type f -print >> $VERSIONDIR/$component
            ;;
        esac
        if [ ! -e $VERSIONDIR/$component ]; then
            echo "!!! installation of $VERSIONDIR/$component failed for some reason"
            exit 1
        fi
    fi
done
