signature XMLS = sig

    datatype xml = ELEMENT of string * xml list | 
                   STRING of substring | 
                   TAG of substring

  (* Get content from given XML tag *)
  val getContent : (string * xml) -> xml list

  (* Get content from given XML tag as a string *)
  val getString : (string * xml) -> string

  (* Parse string into XML structure *)
  val parse : string -> xml

end