structure Util : UTIL  = struct

  datatype direction = LEFT | RIGHT


  fun eq x y = x = y

  fun member x = List.exists (eq x)

  fun sameElements(l1,l2) = length(l1) = length(l2) andalso (List.all (fn x => member x l1) l2)

  fun keymember(x):(('a * ''b) list -> bool) = List.exists ((eq x) o (#2))

  fun println s = print (s^"\n")

  fun mapAllButFirst f list =
    case list of [] => [] | x::t => x::map f t

  fun mapAllButLast f = rev o (mapAllButFirst f) o rev

  fun mapFirstAndLast f l = f ((hd l),(hd (rev l)))


  fun find key = List.find (fn(k,_) => key = k)
  fun findPrefix key = List.find (fn(k,_) => String.isPrefix key k)

  fun lookup key = (Option.map #2) o (find key)
  fun lookupPrefix key = (Option.map #2) o (findPrefix key)

  fun revFind key list = let
    fun rf (pre,suf) =
      case suf of
        [] => (pre,[])
      | x::t => if x = key then (pre,suf) else rf (x::pre,t)
  in
    rf ([],list)
  end

  fun revPairs(l) = case l of
    nil => nil
  | ((x,y)::xs) => (y,x)::revPairs(xs)

  fun delete key = List.filter (fn(k,_) => key <> k)

  fun deleteAll (t:''a list) (s:(''a * ''b) list) =
    case t of [] => s
    | k::u => deleteAll u (delete k s)

  fun moveToFront key list =
    case find key list of
      SOME m => m::(delete key list)
    | NONE => list

  (* insertion sort *)
  fun sort (compare: 'a -> 'a -> bool) (s: 'a list) : 'a list =
    let
      fun insert x t =
        case t of
          [] => [x]
        | y::u => if (compare x y)
                  then x::t
                  else y::(insert x u)
      fun sort' s t =
        case s of
          [] => t
        | x::u => sort' u (insert x t)
    in
      sort' s []
    end

  (* sort an association list by key *)
  fun sortByKey (s: (string * 'a) list) : (string * 'a) list =
    sort (fn(x,_) => fn(y,_) => x <= y) s

  fun removeDuplicates list =
    case list of
      [] => []
    | x::t => x::removeDuplicates(List.filter (fn y => y <> x) t)

  (* elements of x that are not elements of y *)
  fun diff x y = 
    List.filter (fn u => not (member u y)) x

  fun optionalHd (t:'a list) : 'a option = case t of x::_ => SOME x | [] => NONE
  fun optionalTl (t:'a list) : 'a list option = case t of _::x => SOME x | [] => NONE

  fun newId (s:string): unit -> string =
    let val nextId = ref 0
    in fn() => s ^ Int.toString(!nextId) before nextId := !nextId + 1
    end

  val newLibId = newId "L"
  val nextTaskId = ref 0
  val lastTaskId:string list ref = ref []
  fun getTaskId() = hd(tl(tl(tl(!lastTaskId))))
  val newTaskId = fn() => let val () = lastTaskId := ("T" ^ Int.toString(!nextTaskId))::(!lastTaskId)
                          in
                              "T" ^ Int.toString(!nextTaskId) before nextTaskId := !nextTaskId + 1
                          end
  val newProofId = newId "P"

  fun notc (c:char) = fn x => x <> c

  fun endsWith(str:string,endstr:string) = let
   val subS = String.extract(str ,String.size(str) -String.size(endstr) ,NONE)
  in
   subS = endstr
  end


  (* Ref to function for getting user input
   * Takes string of query to ask and list of
   * possible responses.  Returns int option
   * of response's index
   *
   * This version is for CLI interface, update ref
   * for another interface in file for it          *)
  val ask = ref (fn (query:string, responses:string list) => let
    val _ = print query
    val inputLine = TextIO.inputLine TextIO.stdIn
    val tokenizedInput = String.tokens Char.isSpace inputLine
    val numbers = ListPair.zip(responses,List.tabulate(length responses,fn x => x))
  in
    case tokenizedInput of
      [] => SOME 0
    | [x] => Option.map #2 (List.find (String.isPrefix x o #1) numbers)
    | _ => NONE
  end)



  (* CPS-style function similar to ask.  Passes
   * response to continuation                   *)
  val ask2 = ref (fn (query:string, responses:string list) => fn (cont:int option -> unit) => let
    val _ = print query
    val inputLine = TextIO.inputLine TextIO.stdIn
    val tokenizedInput = String.tokens Char.isSpace inputLine
    val numbers = ListPair.zip(responses,List.tabulate(length responses,fn x => x))
  in
    case tokenizedInput of
      [] => cont (SOME 0)
    | [x] => cont (Option.map #2 (List.find (String.isPrefix x o #1) numbers))
    | _ => cont (NONE)
  end)





  (* Functions for printing out, may be updated for when designing a new UI *)
  (* Error *)
  val alert = ref println
  (* Completed task *)
  val done = ref println
  (* Print terms, focus, etc. *)
  val printtext = ref println
  (* Print w/ no new lines *)
  val print = ref print





  fun index (x:''a) (m:''a list) : int option = let
    fun index' (m:''a list) (n:int) : int option =
      case m of
        [] => NONE
      | y::t =>
          if y = x then SOME n
          else index' t (n+1)
  in
    index' m 0
  end

  fun isSubString x name = if String.size(name)=0 then false
                           else ((String.isPrefix x name) orelse
                                (isSubString x (String.extract(name,1,NONE))))

  fun replaceChar x y str = implode(map (fn z => if z = x then y else z) 
                                (explode(str)))

  fun replaceCharWS x y str = implode(List.concat(map (fn z => if z = x then explode(y) else [z]) 
                                (explode(str))))

  fun insertString x y n = (String.substring(x,0,n))^y^(String.extract(x,n,NONE))

end
