signature UTIL = sig

    (* Prints an alert message.
     * Redefine for new interface *)
    val alert : (string -> unit) ref

    (* Prints message when completed task
     * Redefine for new interface *)
    val done : (string -> unit) ref

    (* Asks the user to select from a list.
     * Redefine for new interface
     * Replaced with ask2, do not need this one *)
    val ask : (string * string list -> int option) ref

    (* Asks user to select from a list.
     * Passes result to specified continuation.
     * Redefine for new interface *)
    val ask2 : (string * string list -> (int option -> unit) -> unit) ref

    (* Delete (key,item) pairs from a list
     * based on the key (list of keys). *)
    val delete : ''a -> (''a * 'b) list -> (''a * 'b) list
    val deleteAll : ''a list -> (''a * ''b) list -> (''a * ''b) list

    (* Return items in the first list
     * that are not in the second list. *)
    val diff : ''a list -> ''a list -> ''a list

    (* Determine if the first string ends with
     * the second one *)
    val endsWith : string * string -> bool

    (* Are the two arguments equal? *)
    val eq : ''a -> ''a -> bool

    (* Return the (key,item) pair that matches
     * the given key *)
    val find : ''a -> (''a * 'b) list -> (''a * 'b) option

    (* Find a (key,item) pair where the key
     * is a string and the supplied string
     * is at the beginning of the key. *)
    val findPrefix : string -> (string * 'a) list -> (string * 'a) option

    (* Find index of item in list *)
    val index : ''a -> ''a list -> int option

    (* Is the first argument a substring of the second? *)
    val isSubString : string -> string -> bool

    (* Is there a (_,item) pair in the list? *)
    val keymember : ''a -> ('b * ''a) list -> bool

    (* Lookup the value for a key in a list *)
    val lookup : ''a -> (''a * 'b) list -> 'b option

    (* Lookup value in list by string, which is prefix
     * of key *)
    val lookupPrefix : string -> (string * 'a) list -> 'a option

    (* Map function to all item except the first (last) *)
    val mapAllButFirst : ('a -> 'a) -> 'a list -> 'a list
    val mapAllButLast : ('a -> 'a) -> 'a list -> 'a list

    (* Apply function to first and last item of list *)
    val mapFirstAndLast : ('a * 'a -> 'b) -> 'a list -> 'b

    (* Is item a member of the list? *)
    val member : ''a -> ''a list -> bool

    (* Move (key,item) pair to front of list based on key *)
    val moveToFront : ''a -> (''a * 'b) list -> (''a * 'b) list

    (* Get a new, unique id (theorem id, proof id,task id) *)
    val newId : string -> unit -> string
    val newLibId : unit -> string
    val newProofId : unit -> string
    val newTaskId : unit -> string

    val nextTaskId: int ref

    (* Are the two characters not the same? *)
    val notc : char -> char -> bool

    (* Return head (tail) of list *)
    val optionalHd : 'a list -> 'a option
    val optionalTl : 'a list -> 'a list option

    (* Print (with new line) *)
    val print : (string -> unit) ref
    val println : string -> unit

    (* Print regular text
     * Redefine for new interfact *)
    val printtext : (string -> unit) ref

    (* Remove duplicate items in a list *)
    val removeDuplicates : ''a list -> ''a list

    (* Replace a character in a string with another character(string) *)
    val replaceChar : char -> char -> string -> string
    val replaceCharWS : char -> string -> string -> string

    (* Insert a string at the given point *)
    val insertString : string -> string -> int -> string

    (* Make (key,item) list an (item,key) list *)
    val revPairs : ('a * 'b) list -> ('b * 'a) list

    (* Determine if two lists have the same elements *)
    val sameElements : ''a list * ''a list -> bool

    (* Sort list using comparison (key) function *)
    val sort : ('a -> 'a -> bool) -> 'a list -> 'a list
    val sortByKey : (string * 'a) list -> (string * 'a) list

    (* Side for unification in citation *)
    datatype direction = LEFT | RIGHT
end