signature UNIFY = sig

  type term = Term.term
  type eqn = Term.eqn
  type cond_eqn = Term.cond_eqn
  type substitution = Term.substitution

  (* Convert substitution to string (structure) *)
  val substToString : substitution -> string
  val substToStringWC : substitution -> string
  val substStructure : substitution -> string

  (* compose substitutions -- apply second subst to first *)
  val compose : substitution -> substitution -> substitution

  (* Apply substitution to a conditional equation *)
  val applyToCondEqn : substitution -> cond_eqn -> cond_eqn

  (* Unify two terms (without asking user to resolve ambiguities) *)
  val unify : term * term -> substitution option
  val unifyNoRes : term * term -> substitution option

  (* Unify two equations (without asking user to resolve ambiguities) *)
  val unifyEqn : eqn * eqn -> substitution option
  val unifyEqnNoRes : eqn * eqn -> substitution option

  (* Apply a substitution to a term (equation) *)
  val apply : substitution -> term -> term
  val applyToEqn : substitution -> eqn -> eqn

  (* resolve ambiguities by user input *)
  (* precondition: length of s >= 2 *)
  (* This one is for CLI, may be updated for other UIs *)
  val resolveSubst : (substitution list -> substitution option) ref
end