structure KAT_CLI = struct

  open KAT

  (***********************************************
 * command loop
 ***********************************************)

  (* main read-eval-print loop *)
  fun repl() = let
    val inputLine = ((!print) ">"; TextIO.inputLine TextIO.stdIn)
    val input = String.tokens Char.isSpace inputLine
  in
    doCommand input;
    app println (!outputstring);
    outputstring := nil;
    doHeuristics();
    doSuggest();
    app println (!outputstring);
    outputstring := nil;
    app println (!usuggest);
    usuggest := nil;
    app println (!fsuggest);
    fsuggest := nil;
    viewCurrentTask();
    outputstring := nil;
    conclusion();
    (if focusing() then (println (displayCurrentFocus()))
     else if !outputstring <> nil
          then (println ("\n"^(hd (rev(!outputstring)))))
          else ());
    outputstring := nil;
    repl()
  end

  fun go() =
   (SMLofNJ.Internals.GC.messages false;
    println "KAT interactive theorem prover version 03.9.12";
    SMLofNJ.Cont.callcc (fn c =>
      (exitCont := c;
       SMLofNJ.Cont.callcc (fn c =>
         (errorCont := c;
          readInitFile();
          repl()));
       println "terminating abnormally";
       SMLofNJ.Cont.throw (!exitCont) ())))

  (* call this to build the system *)
  fun build() =
    let fun main(s:string,t:string list) = (go(); OS.Process.success)
    in SMLofNJ.exportFn("../Bin/KAT",main)
    end

end