structure Parser : PARSER = struct

(*  structure SLang = Interpretation(SLang)
  structure PP = PPrint(SLang) *)
    
  structure SLangLrVals = SLangLrValsFun(structure Token = LrParser.Token)
  structure SLangLex = SLangLexFun(structure Tokens = SLangLrVals.Tokens)
  structure SLangParser = Join(structure LrParser = LrParser
			     structure ParserData = SLangLrVals.ParserData
			     structure Lex = SLangLex)
    
  exception Error
  exception Continue
  
  val invoke = fn lexstream =>
    let val error = fn (s, i, _) =>
      ((!Util.alert) ("ERROR (Line " ^ (Int.toString i) ^ "): " ^ s ^ "\n"); raise Continue)
    in
      SLangParser.parse(0, lexstream, error, ())
    end
    handle Continue => raise Fail "Unable to parse"

  fun parse filename = 
    let
      val _ = SLangLex.UserDeclarations.pos := 1
      val h = TextIO.openIn filename
      handle exn => raise Fail ("file " ^ filename ^ " not found")
      val lexer = SLangParser.makeLexer (fn _ => TextIO.input h)
      val (result, _) = invoke lexer
    in
      result
    end			   


  fun parseLine slang = 
    let
      val _ = SLangLex.UserDeclarations.pos := 1
      val h = TextIO.openString slang
      val lexer = SLangParser.makeLexer (fn _ => TextIO.input h)
      val (result, _) = invoke lexer
    in
      result
    end			   
end
