structure SLang : SLANG = struct

  datatype loc = Var of string | Arr of string * (A list) | LPhi |
                 GVar of string | Sub of loc * loc * loc |
                 ASub of loc * loc * A | LPre

  and A = 
    N     of int 
  | Loc   of loc
  | Plus  of A * A
  | Minus of A * A
  | Times of A * A
  | Div   of A * A
  | Mod   of A * A
  | RepA   of A * A * A
  | AFCall of string * A list


  and B =
    True
  | False
  | Equals of A * A
  | LessEq of A * A
  | GreEq  of A * A
  | Less   of A * A
  | Gre    of A * A
  | Not    of B
  | And    of B * B
  | Or     of B * B

  and C =
    Assign of loc * A
  | Seq of C list
  | Cond of B * C * C
  | While of B * C
  | FCall of string * A list
  | Boolean of B
  | FunDef of string * A list * C

(* Not able to parse into the following; only used for reasoning*)

  | Math of A
  | Rep of C * A *A
  | Phi
  | Pre
  | One
end
