/******************************************************************************
 *  File: BasicMesh.hpp
 *  Basic mesh data structure
 *  Copyright (c) 2008 by Changxi Zheng
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
#ifndef GEOMETRIC_BASIC_MESH_HPP
#   define GEOMETRIC_BASIC_MESH_HPP

#include <vector>
#include "Point3.hpp"
#include "linearalgebra/Vector3.hpp"

#ifdef USE_NAMESPACE
namespace carbine
{
#endif

template <typename T>
class BasicMesh
{
    protected:
        std::vector< Point3<T> >    m_vertices;
        std::vector< Vector3<T> >   m_normals;
};

#ifdef USE_NAMESPACE
}
#endif
#endif
