/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#include "harmonic_fluids.hpp"
#include "linearalgebra/Tuple3.hpp"
#include "JobRunner.hpp"

bool_t xdr_tuple3d(XDR *xdrs, Tuple3d *objp)
{
     if (!xdr_double(xdrs, &objp->x))
         return FALSE;
     if (!xdr_double(xdrs, &objp->y))
         return FALSE;
     if (!xdr_double(xdrs, &objp->z))
         return FALSE;
    return TRUE;
}

/*
 * decode and free
 */
bool_t xdr_bubble(XDR *xdrs, hf_bubble* bub)
{
    if ( !xdr_int(xdrs, &bub->id) || 
         !xdr_double(xdrs, &bub->freq) ||
         !xdr_double(xdrs, &bub->rad)  ||
         !xdr_tuple3d(xdrs, &bub->pos) )
        return FALSE;

    if ( !xdr_array(xdrs, (char **)&bub->regular_src[0].val,
                (u_int *)&bub->regular_src[0].len, ~0, 
                sizeof(Point3d), (xdrproc_t)xdr_tuple3d) ||
         !xdr_array(xdrs, (char **)&bub->regular_src[1].val,
                (u_int *)&bub->regular_src[1].len, ~0, 
                sizeof(Point3d), (xdrproc_t)xdr_tuple3d) )
        return FALSE;

    return TRUE;
}

bool_t xdr_complex(XDR *xdrs, std::complex<double>* c)
{
    return (xdr_double(xdrs, &(c->real())) &&
            xdr_double(xdrs, &(c->imag())));
}

bool_t xdr_result(XDR *xdrs, hf_result* ret)
{
    if ( !xdr_int(xdrs, &ret->id) ) return FALSE; 
    if ( !xdr_array(xdrs, (char **)&ret->c, (u_int*)&ret->len,
            ~0, sizeof(std::complex<double>), (xdrproc_t)xdr_complex) )
        return FALSE;
    return xdr_vector(xdrs, (char *)ret->fittingError, 2, 
                    sizeof(double), (xdrproc_t)xdr_double);
}

bool_t xdr_results(XDR *xdrs, const hf_results* objp)
{
    return xdr_array(xdrs, (char **)&objp->val, (u_int *)&objp->len,
            ~0, sizeof(hf_result), (xdrproc_t)xdr_result);
}

/*
 * decode and free
 */
bool_t xdr_bubbles(XDR *xdrs, hf_bubbles* objp)
{
    if ( !xdr_double(xdrs, &(objp->ts)) ) return FALSE;
    return xdr_array(xdrs, (char **)&objp->val, (u_int *)&objp->len,
                ~0, sizeof(hf_bubble), (xdrproc_t)xdr_bubble);
}

bool_t xdr_solid_sample(XDR* xdrs, hf_solid_sample* objp)
{
    if ( !xdr_int(xdrs, &objp->len) ) return FALSE;

    if ( objp->vtx == NULL && xdrs->x_op == XDR_DECODE && objp->len )
    {
        objp->vtx = new Point3d[objp->len];
        objp->w   = new double[objp->len];
        if ( objp->vtx == NULL || objp->w == NULL )
        {
            fprintf(stderr, "xdr_solid_samples: out of memory!\n");
            return FALSE;
        }
    }

    if ( xdrs->x_op == XDR_FREE )
    {
        delete []objp->vtx;
        delete []objp->w;
    }
    else
    {
        if ( !xdr_vector(xdrs, (char *)objp->vtx, objp->len, 
                    sizeof(Point3d), (xdrproc_t)xdr_tuple3d) )
            return FALSE;
        if ( !xdr_vector(xdrs, (char *)objp->w, objp->len,
                    sizeof(double), (xdrproc_t)xdr_double) )
            return FALSE;
    }

    return TRUE;
}

bool_t xdr_surf_sample(XDR* xdrs, hf_surf_sample* objp)
{
    if ( !xdr_int(xdrs, &objp->len) ) return FALSE;

    if ( objp->vtx == NULL && xdrs->x_op == XDR_DECODE && objp->len )
    {
        objp->vtx = new Point3d[objp->len];
        objp->nml = new Vector3d[objp->len];
        objp->w   = new double[objp->len];
        if ( objp->vtx == NULL || objp->nml == NULL || objp->w == NULL )
        {
            fprintf(stderr, "xdr_surf_sample: out of memory!\n");
            return FALSE;
        }
    }

    if ( xdrs->x_op == XDR_FREE )
    {
        delete []objp->vtx;
        delete []objp->nml;
        delete []objp->w;
    }
    else
    {
        if ( !xdr_vector(xdrs, (char *)objp->vtx, objp->len,
                    sizeof(Point3d), (xdrproc_t)xdr_tuple3d) )
            return FALSE;
        if ( !xdr_vector(xdrs, (char *)objp->nml, objp->len,
                    sizeof(Vector3d), (xdrproc_t)xdr_tuple3d) )
            return FALSE;
        if ( !xdr_vector(xdrs, (char *)objp->w, objp->len,
                    sizeof(double), (xdrproc_t)xdr_double) )
            return FALSE;
    }
    return TRUE;
}

bool_t xdr_samples(XDR *xdrs, hf_samples* objp)
{
    if ( !xdr_double(xdrs, &objp->ts) ) return FALSE;

    if ( !xdr_surf_sample(xdrs, &(objp->surf_samples[0])) ) return FALSE;

    if ( !xdr_vector(xdrs, (char *)objp->solid_samples, 4,
                sizeof(hf_solid_sample), (xdrproc_t)xdr_solid_sample) )
        return FALSE;

    return TRUE;
}

bool_t xdr_samples_enc(XDR* xdrs, cluster_config_arg* objp)
{
    if ( xdrs->x_op != XDR_ENCODE )
    {
        fprintf(stderr, "ERROR! ENCODE\n");
        exit(1);
    }

    double ts = objp->job->timestamp();
    if ( !xdr_double(xdrs, &ts) ) return FALSE;                 // timestep ts

    int n = objp->samples[0]->num_vertices();
    if ( !XDR_PUTINT32(xdrs, &n) ) return FALSE;                // free.len

    const Point3d* ptrP = &(objp->samples[0]->vertices()[0]);   // free.vtx
    if ( !xdr_vector(xdrs, (char *)ptrP, n,
                sizeof(Point3d), (xdrproc_t)xdr_tuple3d) )
        return FALSE;

    const Vector3d* ptrV = &(objp->samples[0]->normals()[0]);   // free.nml
    if ( !xdr_vector(xdrs, (char *)ptrV, n,
                sizeof(Vector3d), (xdrproc_t)xdr_tuple3d) )
        return FALSE;

    const double* ptrA = &(objp->samples[0]->vertex_areas()[0]); // free.nml
    if ( !xdr_vector(xdrs, (char *)ptrA, n, sizeof(double),
                (xdrproc_t)xdr_double) )
        return FALSE;

    for(int i = 1;i < 5;++ i)
        if ( !xdr_solid_sample_enc(xdrs, objp->samples[i]) )
            return FALSE;

    return TRUE;
}

bool_t xdr_solid_sample_enc(XDR *xdrs, const TriangleMesh<double>* mesh)
{
    int n = mesh->num_vertices();
    if ( !xdr_int(xdrs, &n) ) return FALSE;

    const Point3d* ptrP = &(mesh->vertices()[0]);
    if ( !xdr_vector(xdrs, (char *)ptrP, n, 
                sizeof(Point3d), (xdrproc_t)xdr_tuple3d) )
        return FALSE;
    const double* ptrA = &(mesh->vertex_areas()[0]);
    if ( !xdr_vector(xdrs, (char *)ptrA, n,
                sizeof(double), (xdrproc_t)xdr_double) )
        return FALSE;

    return TRUE;
}

/*
bool_t xdr_bubble_enc(XDR* xdrs, Bubble<double>* bub)
{
    if ( !XDR_PUTINT32(xdrs, (const int32_t*)&bub->id) ||
         !xdr_double(xdrs, &bub->omegad) ||
         !xdr_double(xdrs, &bub->rad)  ||
         !xdr_tuple3d(xdrs, &bub->pos) )
        return FALSE;

    if ( !XDR_PUTINT32(xdrs, &bub->numSrc[0]) )
        return FALSE;
    for(int i = 0;i < bub->numSrc[0];++ i)
        if ( !xdr_tuple3d(xdrs, const_cast<Point3d*>(bub->regularSrc[0][i])) )
            return FALSE;

    if ( !XDR_PUTINT32(xdrs, &bub->numSrc[1]) )
        return FALSE;
    for(int i = 0;i < bub->numSrc[1];++ i)
        if ( !xdr_tuple3d(xdrs, const_cast<Point3d*>(bub->regularSrc[1][i])) )
            return FALSE;
    return TRUE;
}

bool_t xdr_bubbles_enc(XDR *xdrs, const std::vector<Bubble<double>*> *objp)
{
    if ( xdrs->x_op != XDR_ENCODE ) 
    {
        fprintf(stderr, "ERROR! ENCODE\n");
        exit(1);
    }
    const int n = (int)objp->size();
    if ( !XDR_PUTINT32(xdrs, &n) ) return FALSE;

    for(int i = 0;i < n;++ i)
        if ( !xdr_bubble_enc(xdrs, (*objp)[i]) ) return FALSE;
    return TRUE;
}
*/

