#ifndef _MINCUT_H_
#define _MINCUT_H_

#define numtype long long
#define bool char
#define true 1
#define false 0

typedef struct Graph *Graph_t;
typedef struct Edge *Edge_t;
typedef struct Node *Node_t;
typedef struct AvailHeight *AvailHeight_t;
typedef struct AvailNode *AvailNode_t;
typedef struct Height *Height_t;
typedef struct iid *iid_t;

/* Graph Data Structures */
typedef struct Graph {
  int n;
  Node_t nodes;
  int sourceQueue;
  int sink;
  AvailHeight_t excess;
  Height_t height;
  Height_t heightn;
  int nextCluster;
}Graph;


typedef struct Node {
  Edge_t firstEdge;      // mincut: REQ obvious
  int height;            // mincut: SET used in preflow push algorithm
  numtype excess;        // mincut: SET used in preflow push algorithm
  int next;              // mincut: SET used for link list of nodes
  int prev;              // mincut: SET used for link list of nodes

  int nextNode;          // cluster: SET source queue link list
  int prevNode;          // cluster: SET source queue link list
  int nextComm;          // cluster: SET for a node the next item in that community
  bool deleted;          // cluster: SET true if node is a representative community
  int commsize;          // cluster: SET number of other graph nodes in community if deleted = false else should be zero
  int numnodes;          // cluster: REQ used to set alpha edges for the graph
  int parent;            // cluster: SET each node points to the node representing the community
  bool toCluster;        // cluster: REQ number of communities the node represents BAD we could instead use a bit to add or not add

  iid_t ids;             // writeComms:
  iid_t lastid;          // writeComms:
  int numtrue;

  bool visited;          // mincut: SET used for depth first search
} Node;


typedef struct Edge {
  numtype flow;
  numtype capacity;
  int toNode;
  Edge_t oppositeEdge;
  Edge_t nextEdge;
  Edge_t prevEdge;
} Edge;

// Each height will consist of two pointers:
// One pointing up to the next available height
// One pointing to the queue of available nodes at this height
typedef struct AvailHeight {
  AvailHeight_t nextAvailHeight;
  int height;
  AvailNode_t heightAvailNodes;
} AvailHeight;
typedef struct AvailNode {
  AvailNode_t nextAvailNode;
  AvailNode_t prevAvailNode;
  int nodeNum;
} AvailNode;

typedef struct iid {
  iid_t nextId;
  int item;
}iid;

typedef struct Height {
  Height_t above;
  Height_t below;
  int height;
  int nodes;
}Height;

int MinCut(Graph_t G);
void Relabel(Graph_t G, Node_t node);
void DoGapRelabelEnd(Graph_t G);
void Push(Graph_t G, Node_t v, Edge_t e);
int makeMinCut(Graph_t G);

#endif
