#include <stdio.h>
#include <stdlib.h>
#include "iolib.h"
#include "mincut.h"


/* Load a graph from disk into memory */
Graph_t parseInputFile(char *edgelist, char *ids, numtype alphaN, numtype alphaD) {
  FILE *file, *idfile;
  int numnodes, numedges, i, fromNode, toNode;
  Node_t fNode, tNode;
  Edge_t bedge, fedge, edgeIterator;
  Graph_t G;
  bool edgeExists;

  // file should have the number of nodes then number of edges
  // in the first line
  file = fopen(edgelist, "r");
  fscanf(file, "%d", &numnodes);
  fscanf(file, "%d", &numedges);

  // allocate graph
  G = new Graph;
  G->n = numnodes + 1;
  G->nodes = new Node[numnodes + 1];

  /* INITIALIZE ALL NODES */
  // from every node except t add an edge to t
  // and one edge from t to that node
  G->nodes[numnodes].firstEdge = NULL;
  for (i = 0; i < numnodes; i++) {
    // allocate a doubly edge with capacity 1
    fedge = new Edge;
    bedge = new Edge;
    fedge->capacity = bedge->capacity = 1*alphaN;
    fedge->oppositeEdge = bedge;
    bedge->oppositeEdge = fedge;
    fedge->toNode = numnodes;
    bedge->toNode = i;
    // add forwards edge
    fedge->prevEdge = NULL;
    fedge->nextEdge = NULL;
    G->nodes[i].firstEdge = fedge;
    // add backwards edge
    bedge->prevEdge = NULL;
    if (G->nodes[numnodes].firstEdge != NULL)
      G->nodes[numnodes].firstEdge->prevEdge = bedge;
    bedge->nextEdge = G->nodes[numnodes].firstEdge;
    G->nodes[numnodes].firstEdge = bedge;
    G->nodes[i].commsize = 1;
    G->nodes[i].numnodes = 1;
    G->nodes[i].toCluster = true;
    G->nodes[i].ids = NULL;
    G->nodes[i].lastid = NULL;
    G->nodes[i].numtrue = 0;
  }


  /* Setup the item IDs for each node */
  idfile = fopen(ids, "r");
  int temp1, temp2, cnodes;
  fscanf(idfile,"%d",&cnodes);
  for (i = 0; i < cnodes; i++){
    fscanf(idfile,"%d",&temp1);
    fscanf(idfile,"%d",&temp2);
    G->nodes[temp1].ids = new iid;
    G->nodes[temp1].ids->nextId = NULL;
    G->nodes[temp1].ids->item = temp2;
    G->nodes[temp1].lastid = G->nodes[temp1].ids;
    G->nodes[temp1].numtrue = 1;
    //fprintf(stderr,"ids %d\n",G->nodes[temp1].ids);
  }
  fclose(idfile);

  // Initialize the start Queue
  for (i = 0; i < numnodes; i++) {
    G->nodes[i].nextNode = i+1;
    G->nodes[i].prevNode = i-1;
    G->nodes[i].deleted = false;
    G->nodes[i].commsize = 1;
  }
  G->nodes[numnodes-1].nextNode = -1;
  G->sourceQueue = 0;

  // Read edges file and add to graph
  for (i = 0; i < numedges; i++) {
    fscanf(file, "%d", &fromNode);
    fscanf(file, "%d", &toNode);
    fNode = &G->nodes[fromNode];
    tNode = &G->nodes[toNode];

    // check if edge exists already
    // if edge exists already then there was an edge
    // from tNode to fNode and we increase the capacity
    edgeIterator = fNode->firstEdge;
    edgeExists = false;
    while (edgeIterator != NULL) {
      if (edgeIterator->toNode == toNode) {
        //printf("what the hell is going on\n");
        edgeIterator->capacity = 2*alphaD;
        edgeIterator->oppositeEdge->capacity = 2*alphaD;
        edgeExists = true;
        break;
      }
      edgeIterator = edgeIterator->nextEdge;
    }

    // if edge does not exist add it
    if (!edgeExists) {
      // create doubly edge
      fedge = new Edge;
      bedge = new Edge;
      fedge->capacity = bedge->capacity = alphaD;
      fedge->oppositeEdge = bedge;
      bedge->oppositeEdge = fedge;
      fedge->toNode = toNode;
      bedge->toNode = fromNode;
      // add forwards edge
      fedge->prevEdge = NULL;
      fedge->nextEdge = fNode->firstEdge;
      fNode->firstEdge->prevEdge = fedge;
      fNode->firstEdge = fedge;
      // add backwards edge
      bedge->prevEdge = NULL;
      bedge->nextEdge = tNode->firstEdge;
      tNode->firstEdge->prevEdge = bedge;
      tNode->firstEdge = bedge;
    }
  }
  return G;
}

void PrintGraph(Graph_t G){
  for(int i = 0; i < G->n;i++){
    Edge_t e;
    //printf("Node %d: excess %d%d, id %d height %d\n",i,G->nodes[i].excess,G->nodes[i].id,G->nodes[i].height);
    //printf("Node %d: excess %d%d, height %d\n",i,G->nodes[i].excess,G->nodes[i].height);
    printf("Node %d: numnodes %d, commsize %d\n",i,G->nodes[i].numnodes,G->nodes[i].toCluster);
    e = G->nodes[i].firstEdge;
    while ( e != NULL){
      //printf("[%d,%d]: capacity: %ld flow %ld\n",i,e->toNode,e->capacity,e->flow);
      printf("[%d,%d]:\n",i,e->toNode);
      e = e->nextEdge;
    }
  }
}
