#ifndef _CLUSTER_H_
#define _CLUSTER_H_
#include "mincut.h"


int checkOtherNode(Graph_t G);

int checkNumTrue(Graph_t G);

// write the clustering of the given graph to disk
void writeClusters(Graph_t G, FILE *file, numtype alpha,int truetotal);

// given the graph it gives the next subgraph data structure
Graph_t nextGraph(Graph_t G, int *nextComm);

int freeGraph(Graph_t G);

Graph_t compressGraph(Graph_t G);

// cluster the given graph G using the given value of alpha
// we assume that the graph has an artificial sink already at
// the end of the node array.
// So G->nodes[G->n-1] is the sink node
int cluster(Graph_t G, numtype alpha);


void printComm(Graph_t G, int node, int max);

void writeAll(Graph_t G, FILE *file, numtype alpha);

#endif
