
open Ast

module E = Equations_types

let print (v : expr) : expr =
  match v with
    | EString s -> Printf.printf "%s" s; EUnit
    | EInt n -> Printf.printf "%d" n; EUnit
    | EBool b -> Printf.printf "%B" b; EUnit
    | _ -> 
      print_string( Printing.to_string (v, Environment.Environment.empty));
      EUnit
    (*| _ -> Ast.runtime "don't know how to print this"*)

let float_of_int2 (i : expr) : expr = match i with
  | EInt(j) -> EFloat(float_of_int j)
  | _ -> Ast.runtime "ENative float_of_int failed"
 
let string_of_int2 (i: expr) : expr = match i with
  | EInt(j) -> EString(string_of_int j)
  | _ -> Ast.runtime "ENative string_of_int failed"

let string_of_float2 (f: expr) : expr = match f with
  | EFloat(j) -> EString(string_of_float j)
  | _ -> Ast.runtime "ENative string_of_float failed"

exception Failwith of string
let failwith2 (a:expr) : expr = match a with
  | EString s -> raise (Failwith s)
  | _ -> Ast.runtime "ENative failwith failed"

let natives = [
  ("print", print, let t = E.newEVar() in TArrow (t, TUnit));
  ("float_of_int", float_of_int2, TArrow(TInt, TFloat));
  ("string_of_int", string_of_int2, TArrow(TInt, TString));
  ("string_of_float", string_of_float2, TArrow(TFloat, TString));
  ("failwith", failwith2, let t = E.newEVar() in TArrow(TString, t))
]
