(* In CoCaml: *)
(* A = int, for now at least *)
(* type state = int * (state * int) list *)
(*
type stream = State of int * (stream * int) list
*)
(*
let q1 =
  let q1 = State(0, []) in
  let q2 = State(0, []) in
  (/* need to make the and, for now explicit use of Landin's knot */)
  q1 := State(1, [ q1, 0; q2, 1 ]);
  q2 := State(2, [ q1, -1; q2, 2 ]);
  q1
*)
(*
let rec q1 =
  let rec q2 = State(2, [q1, -1; q2, 2 ]) in
  State(1, [ q1, 0; q2, 1 ])
*)

type stream = State of stream * stream

let rec q1 =
  let rec q2 = State( q1, q2 ) in
  State( q2 , q2 )



(* But: All three below work in OCaml *)
type stream = State of int * (stream * int) list

(* and not implemented in CoCaml *)
let rec q1 = State(1, [q1, 0; q2, 1]) 
and q2 = State(2, [q1, -1; q2, 2])

let q1 = (* wrong result in CoCaml; see below *)
  let q1 = ref (State(0, [])) in
  let q2 = ref (State(0, [])) in
  (* need to make the and, for now explicit use of Landin's knot *)
  q1 := State(1, [ q1, 0; q2, 1 ]);
  q2 := State(2, [ q1, -1; q2, 2 ]);
  !q1

let rec q1' = (* runs forever in CoCaml *)
  let rec q2 = State(2, [q1', -1; q2, 2 ]) in
  State(1, [ q1', 0; q2, 1 ])

(* but not this fourth one, that behaves like CoCaml *)
type stream2 = State2 of int * (stream2 ref * int) list

let q1 =
  let q1 = ref (State2(0, [])) in
  let q2 = ref (State2(0, [])) in
  q1 := State2(1, [ !q1, 0; !q2, 1 ]);
  q2 := State2(2, [ !q1, -1; !q2, 2 ]);
  !q1
