module type Mtype = sig
  val f: 'a -> 'a
  val fib: int -> int
end

module M : Mtype = struct
  let f = function x -> x
  let g = function x -> 2
  let rec fib n = if n = 0 || n = 1 then 1 else fib (n-1) + fib (n-2)
end

let _ = print_int (M.f 3)
(*let _ = print_int (M.g ())*)
let _ = print_int (M.fib 35)
let _ = print_newline()

