(***********************************)
(* Using JB's user defined solvers *)
(***********************************)

type expression = 
    Val of float 
  | Plus of expression * expression
  | Mul  of expression * expression
(* The Unknown case is implicit, it is added to every sum type *)

let rec convert_eq_aux e = match e with
  | Plus(e1, e2) -> (match convert_eq_aux e1, convert_eq_aux e2
    with (l1, f1), (l2, f2) -> (append l1 l2), f1 +. f2)
  | Mul(Unknown(x), Val i) -> [ x, i ], 0.
  | Mul(Val i, Unknown(x)) -> [ x, i ], 0.
  | Val f -> [ ], f
  | Unknown x -> [(x,1.)], 0.
  | Plus _ -> failwith "plus"
  | Mul _ -> failwith "mul"
  | Val _ -> failwith "val"
  | Unknown _ -> failwith "unknown"
  | e -> failwith "Expression not suitable for gaussian elimination"

let jbgaussian = udgaussian convert_eq_aux

(**** Probability of Heads ****)
let corec[jbgaussian] probability t = match t with
  | Heads -> Val 1.
  | Tails -> Val 0.
  | Flip(p, v, w) -> Plus(
      Mul(Val p, probability v),
      Mul(Val (1. -. p), probability w))

let r1 = probability Heads
let r2 = probability Tails
let r3 = probability (Flip(0.3, Heads, Tails))
let r4 = probability (Flip(0.3, Tails, Heads))
let r5 = probability coin0
let r6 = probability coin1

(**** Expected number of flips ****)
let corec[jbgaussian] flips t = match t with
    Heads -> Val 0. | Tails -> Val 0.
  | Flip(p, t1, t2) -> Plus(
    Val 1., 
    Plus(Mul(Val p, flips t1),
	 Mul(Val (1. -. p), flips t2)))

let r7 = flips Heads
let r8 = flips Tails
let r9 = flips (Flip(0.3, Heads, Tails))
let r10 = flips (Flip(0.3, Tails, Heads))

let r11 = flips coin0
let r12 = flips coin1

(************************************************************)
(* An alternative implementation without the typing problem *)
(* (using JB's solution, not done using Dexter's)           *)
(************************************************************)

let udgaussian2 (x:symbol) (lst:(symbol * expression) list) : expression =
  Val(jbgaussian x lst)

let corec[udgaussian2] probability2 t = match t with
  | Heads -> Val 1.
  | Tails -> Val 0.
  | Flip(p, v, w) -> Plus(
      Mul(Val p, probability2 v),
      Mul(Val (1. -. p), probability2 w))

let r25 = probability2 Heads
let r26 = probability2 Tails
let r27 = probability2 (Flip(0.3, Heads, Tails))
let r28 = probability2 (Flip(0.3, Tails, Heads))
let r29 = probability2 coin0
let r30 = probability2 coin1

let corec[udgaussian2] flips2 t = match t with
    Heads -> Val 0. | Tails -> Val 0.
  | Flip(p, t1, t2) -> Plus(
    Val 1., 
    Plus(Mul(Val p, flips2 t1),
	 Mul(Val (1. -. p), flips2 t2)))

let r31 = flips2 Heads
let r32 = flips2 Tails
let r33 = flips2 (Flip(0.3, Heads, Tails))
let r34 = flips2 (Flip(0.3, Tails, Heads))
let r35 = flips2 coin0
let r36 = flips2 coin1
