module type Mtype = sig
  val f: 'a -> 'a
  val fib: int -> int
end

module M : Mtype = struct
  let f = function x -> x
  let g = function x -> 2
	let rec fib n = if n = 0 || n = 1 then 1 else fib (n-1) + fib (n-2)
end

let _ = print_int (M.f 3)
(*let _ = print_int (M.g ())*)
let _ = print_int (M.fib 10)
let _ = print_newline()


(* Module inside a module? *)
module Hersh = struct
	let y = ref(5)
  let g x = y := (!y)+x; x
	let h x = print_string "Random check"; 4
  module Hersh = struct
    type tree = H | T | Flip of float * tree * tree
    let rec f x = g x
  end
end

let _ = print_int (Hersh.g 1)
let _ = print_int (Hersh.Hersh.f 45)
let _ = print_newline()
let _ = print_int (!Hersh.y)
let _ = print_newline()

(*****************************************************)
(* Do modules have static scoping too? Presumably... *)
let a = 0
let b = 0

module A = struct
  let f = a
  let g = fun x -> b
end

let a, b = 1, 1
let _ = print_int (A.f)
let _ = print_int (A.g "ig")
let _ = print_newline()
(* YES: static scoping! *)

module B = A

let a, b = 2, 2
let _ = print_int (B.f)
let _ = print_int (B.g "ig")
let _ = print_newline()



