(* Q from Helle when presenting at COIN (at CWI Amsterdam, March 5th, 2013:
   Can we represent differential equations on streams, for example:
   x1' = 2 * xi + x2    x1(0) = 1
   x2' = 3 * x1         x2(0) = 2
*)
(* First answer: no, the result is not regular anyway! *)
(* TODO: Alexandra talked about using some vector spaces. Ask her. *)

let corec[constructor] mult p = 
  match p with _, [] -> [] | (i, h :: t) -> (h * i) :: (mult (i, t))
let corec[constructor] div p = 
  match p with _, [] -> [] | (i, h :: t) -> (h / i) :: (div (i, t))

let rec ones = 1 :: ones
let twos = mult (2, ones)

(* x' = 3 * x     x(0) = 3 *)
(*let rec threes = 3 :: (mult (2, threes))*)

let corec[constructor] threes a = 3 :: (mult (2, threes a))
(* let t = threes () *) (* failure "unknown2var: in the constructor solver *)

let corec[iterator ones] threes a = 1 :: (mult (1, threes a))
let t = threes ()
