(********************************************************)
(* Separation with only extensional equality            *)
(********************************************************)

let rec first_recurrence a s l = if mem l s then (rev a,s,l)
  else match l with
    | [] -> (rev a,s,l)
    | h :: t -> first_recurrence (h :: a) (l :: s) t

let separate l =
  match first_recurrence [] [] l with (a,s,l) -> let n = position l s in
      let m = length a - n in
      let s = take a m in
      let t = take (snd s) n in
      (fst s, fst t)

let rec ones = 1 :: ones
let rec onetwo = 1 :: 2 :: onetwo
let rec twoone = 2 :: 1 :: ones
let a = separate ones
let b = separate onetwo
let c = separate twoone
let d = separate (3 :: 4 :: twoone)
let e = separate [1; 2; 3]
let f = separate [1]
let g = separate []

let rec string_of_lis l = match l with
    [] -> ""
  | i :: t -> string_of_int i ^ string_of_lis t

let to_string i = match separate i with
    (l1, []) -> string_of_lis l1
  | (l1, l2) -> string_of_lis l1 ^
      "(" ^ string_of_lis l2 ^ ")"

let printp n = print (to_string n); print "\n"

let ap = printp ones
let bp = printp onetwo
let cp = printp twoone
let dp = printp (3 :: 4 :: twoone)
let ep = printp [1; 2; 3]
let fp = printp [1]
let gp = printp []
