(********************************************************)
(* Separation with only extensional equality            *)
(* author: Jean-Baptiste Jeannin jeannin@cs.cornell.edu *)
(********************************************************)

(* Utilities on lists *)
let hd l = match l with
  | [] -> -1
  | h :: t -> h

let tl l = match l with
  | [] -> []
  | h :: t -> t

let corec[constructor] map arg = match arg with
  | f, [] -> []
  | f, h :: t -> (f h) :: map(f, t)

let rec rev_helper ls = match ls with (l1, l2) ->
      match l1 with
      | [] -> l2
      | h :: t -> rev_helper (t, h :: l2)

let rev l = rev_helper (l, [])

let rec compare args = match args with (l, seen1, seen2) ->
      match seen1 with
      | [] -> None
      | hlist :: tlist -> if l = hlist
          then Some(rev (map (hd, tlist)), ((hd l) :: (map (hd, seen2))))
          else compare (l, tlist, hlist :: seen2)

let rec helper args = match args with (l, seen) ->
      match l with
      | [] -> None (* case of a finite list *)
      | h :: t -> match (compare (l, seen, [])) with
          | None -> helper (t, l :: seen)
          | Some res -> Some res

let rec separate l = match helper (l, []) with
  | None -> (l, [])
  | Some(res) -> res

let rec ones = 1 :: ones
let rec onetwo = 1 :: 2 :: onetwo
let rec twoone = 2 :: 1 :: ones
let a = separate ones
let b = separate onetwo
let c = separate twoone
let d = separate (3 :: 4 :: twoone)

(* almost duplicated from padic.ml for now *)
let rec string_of_lis l = match l with
    [] -> ""
  | i :: t -> string_of_int i ^ string_of_lis t

let to_string i = match separate i with
    (l1, []) -> string_of_lis l1
  | (l1, l2) -> string_of_lis l1 ^
      "(" ^ string_of_lis l2 ^ ")"

let printp n = print (to_string n); print "\n"

let ap = printp ones
let bp = printp onetwo
let cp = printp twoone
let dp = printp (3 :: 4 :: twoone)
