type tree = Heads | Tails | Flip of float * tree * tree

(**** Probability of Heads ****)

let corec[gaussian] probability t = match t with
  (* computes the final probability of Heads *)
    Heads -> 1.
  | Tails -> 0.
  | Flip(p, t1, t2) ->
    p *. probability t1 +. (1. -. p) *. probability t2

let r1 = probability Heads
let r2 = probability Tails
let r3 = probability (Flip(0.3, Heads, Tails))
let r4 = probability (Flip(0.3, Tails, Heads))

let rec coin0 = Flip(0.4, Heads, Flip(0.3, Tails, coin0))
let r5 = probability coin0

let rec coin1 = Flip(0.5, Heads, Flip(0.5, Tails, coin1))
let r6 = probability coin1

let vonneumann p =
  if p > 0. && p < 1.
  then let rec c = Flip(p, Flip(p, c, Heads),
			Flip(p, Tails, c)) in c
  else failwith "vonneumann: p must be in the interval (0;1)"
let r7 = probability (vonneumann 0.3)
let r8 = probability (vonneumann 0.7)
let r9 = probability (vonneumann 0.5)

(**** Expected number of flips ****)

let corec[gaussian] flips t = match t with
    Heads -> 0. | Tails -> 0.
  | Flip(p, t1, t2) -> 1. +. p *. (flips t1) +. (1. -. p) *. (flips t2)

let r10 = flips Heads
let r11 = flips Tails
let r12 = flips (Flip(0.3, Heads, Tails))
let r13 = flips (Flip(0.3, Tails, Heads))

let r14 = flips coin0
let r15 = flips coin1

(**** Outcome function ****)

let corec[constructor] outcome c = match c with
    Heads -> (function s -> Heads)
  | Tails -> (function s -> Tails)
  (* the match is to force both evaluations of outcome c1 and outcome c2
     to let ... in in a row doesn't do the trick *)
  (*| Flip(p, c1, c2) -> match (outcome c1, outcome c2) with
      o1, o2 -> (function h :: t -> if h <= p then o1 t else o2 t)*)
  | Flip(p, c1, c2) -> (function h :: t -> if h <= p then 
      outcome c1 t else outcome c2 t)

let rec s1 = 0.25 :: s1
let r16 = outcome Heads s1
let r17 = outcome (Flip(0.3, Heads, Tails))
let r18 = outcome coin0
       
let r19 = r17 s1
let r20 = r18 s1
