open Ast
open Environment
open Printing

let rec unknown2var (e : expr) = match e with
(* Only the ones that correspond to a constructor qualify *)
| EUnknown (ESymbol x) -> EVar x
| EVar _ | EInt _ | EFloat _ | EString _ | EBool _ | EUnit | EInj(_, None) -> e
| ETuple(el) -> ETuple(List.map unknown2var el)
| EInj(i, Some e1) -> EInj(i, Some (unknown2var e1))
| EFun(el, e) -> EFun(List.map unknown2var el, unknown2var e)
| EFunType(el, tl, e) ->
  EFunType(List.map unknown2var el, tl, unknown2var e)
| EFunction pel -> EFunction(
  List.map (fun (p, e) -> (p, unknown2var e)) pel)
| EMatch(e, pel) -> EMatch(unknown2var e,
  List.map (fun (p, e) -> (p, unknown2var e)) pel)
| EIf(t, e1, e2) -> EIf(unknown2var t,
		      unknown2var e1, unknown2var e2)
| EBinop(b, e1, e2) -> EBinop(b, unknown2var e1, unknown2var e2)
| EApp(e1, e2) -> EApp(unknown2var e1, unknown2var e2)
| EFunCorec _ | ELetType _ | ELetrecType _ | ELetcorecType _ | ESeq _ | EWhile _ | 
  EFor _ | EAssign _ | ENot _ | EDummy | ENative _ | ESymbol _ | EUnknown _
    -> failwith "unknown2var/TODO"

let solve name env eqs =
  let new_eqs = List.map (fun (id, rhs) -> (id, unknown2var rhs)) eqs in
  let new_env =
    List.fold_left
      (fun cur_env (id, rhs) -> Environment.bind id rhs cur_env)
      env new_eqs in
  (Environment.lookup name new_env, new_env)
