open Ast
open Environment
open Printing

let rec solve_aux eval_rhs env eqs (guesses: (id, expr) Hashtbl.t) =
   (* TODO: only on lists so far; extend to the general case *)
  let b, envf = List.fold_left 
    (fun (b, cur_env) (x, rhs) ->
      let g = Hashtbl.find guesses x in
      let cur_env = match g with 
	| ETuple([_; EInj(c, t)]) ->
	  Environment.bind (x ^ "_2") (EInj (c, t)) cur_env
	| ETuple([_; EVar x2]) -> failwith x2
	(* Environment.bind x2 (EVar x2) *)
	| _ -> cur_env in
      let (ng, new_env1), _, _ = eval_rhs (rhs, cur_env) guesses in
      let new_env = match ng with 
	| ETuple([_; EInj(c, t)]) ->
	  Environment.bind (x ^ "_2") (EInj (c, t)) new_env1
	| ETuple([_; EVar x2]) -> failwith x2
	(* Environment.bind x2 (EVar x2) *)
	| _ -> new_env1 in Hashtbl.add guesses x ng;
    (* tests if guesses and new guesses are observationally the same *)
      b && (Equality.equal (g, cur_env) (ng, new_env)), new_env)
    (true, env) eqs in
  if b
  then guesses, envf
  else solve_aux eval_rhs envf eqs guesses

let solve eval bot (name:id) env eqs =
(* the order of the eqs, from bottom to top of the call tree, is ideal *)
  let guesses = Hashtbl.create (List.length eqs) in
  List.iter (fun (x, _) -> Hashtbl.add guesses x bot) eqs;
  let add_guesses guesses env0 = Hashtbl.fold (fun x g env1 -> match g with 
    | ETuple([_; EInj(c, t)]) -> 
      Environment.bind (x ^ "_2") (EInj (c, t)) env1
    | ETuple([_; EVar x2]) -> failwith x2 
    (* Environment.bind x2 (EVar x2) *)
    | _ -> env1) guesses env0 in
  let answers, env = (solve_aux eval (add_guesses guesses env) eqs guesses) in
  Hashtbl.find answers name, env
