open Ast

let check_typedef (t:typedef) : unit =
  let typevars, constructors = snd t in
  List.iter
    (function (_, None) -> ()
      | (_, Some(typ)) -> (
	let fv = Util.HashSet.make() in
	Ast_types.free_vars fv (Ast_types.Schema(typevars, typ));
	if not(Util.HashSet.empty fv) then
	  Equations_types.type_error "Unbound type parameter"))
    constructors
