(***********************************************)
(* User defined Unit solver: just returns unit *)
(***********************************************)

(***************************************)
(* Using Dexter's user defined solvers *)
(***************************************)

type 'a expr =
| Empty
| Cons of int * 'a expr
| Unk of 'a
(* type t = unit *)
(* type var = string *)
let unk (s:string) : string expr = Unk s
let fresh : unit -> string = let c = 0 in 
			     (fun (x:unit) -> c := c+1; string_of_int c)
let solve (s:string) (eqs:(string * string expr) list) = ()

let corec[unk, fresh, solve] fd l = match l with
  | [ ] -> Empty
  | h :: t -> Cons(h, fd t)

let r5 = fd [ ]
let r6 = fd [1]
let r7 = fd [1;2]
let r8 = let rec zeros = 0 :: zeros in fd zeros
