(* cf. Corec/separate.ml *)

(*******************************)
(* Code common to all solution *)
(*******************************)

let rec remove_beginning l pref = match l, pref with
  (* pref should be a prefix of l *)
  | l, [ ] -> l
  | hl :: tl, hp :: tp -> if hl = hp then remove_beginning tl tp
    else failwith "pref not a prefix of l"

let one = [ 1 ]
let two = [ 1; 2 ]
let rec zeros = 0 :: zeros
let rec ones = 1 :: ones
let rec alt = 1 :: 2 :: alt
let rec alt3 = 1 :: 2 :: 3 :: alt3

(***************************************)
(* Using Dexter's user defined solvers *)
(***************************************)
type ('a, 'b) dsep = 
| DI1
| DI2 of 'a * ('a, 'b) dsep
| Unk of 'b

(* Main difference with JB: the Unk in 'a dexpr below,
   and the five functions below: t, var, unk, fresh, eq *)
(* type t = 'a list * 'a list *)
(* type var = string *)
let unk (s:string) : ('a, string) dsep = Unk s
let fresh : unit -> string = let c = 0 in 
			     (fun (x:unit) -> c := c+1; string_of_int c)

let rec dsolve_aux name eqs (seen : (string * 'a list) list) (sofar : 'a list) =
  match assoc_option name seen with
    | Some e1 -> let e = rev e1 in
		 e, remove_beginning (rev sofar) e
    | None -> (match assoc name eqs with
	| DI1 -> rev sofar, [ ]
	| DI2(i, Unk(name2)) -> 
	  let res = i :: sofar in
	  dsolve_aux name2 eqs ((name, sofar) :: seen) res)

let dseparate name eqs = dsolve_aux name eqs [ ] [ ]

let corec[unk, fresh, dseparate] dexterseparate i = match i with
  [] -> DI1
| i :: t -> DI2(i, dexterseparate t)

let r8 = dexterseparate one
let r9 = dexterseparate two
let r10 = dexterseparate ones
let r11 = dexterseparate zeros
let r12 = dexterseparate alt
let r13 = dexterseparate alt3
let r14 = dexterseparate (1 :: 2 :: alt3)
