let p = 7
(* should be prime *)

(* type padic = int list * int list *)
(* only the first one can be infinite *)

let rec minus_one = (p - 1) :: minus_one

(**** Equality ****)
let rec equalf p = match p with (* of floating parts: not corecursive *)
  [], [] -> true
| h1 :: t1, h2 :: t2 -> h1 = h2 && equalf (t1, t2)
| 0 :: t1, [] -> equalf (t1, [])
| [], 0 :: t2 -> equalf (t2, [])
| x -> false

let corec[appears(false)] equali_appears_aux p = match p with 
(* of integer parts *)
  [], [] -> true
| h1 :: t1, h2 :: t2 -> h1 = h2 && equali_appears_aux (t1, t2)
| 0 :: t1, [] -> equali_appears_aux (t1, [])
| [], 0 :: t2 -> equali_appears_aux (t2, [])
| x -> false
let equali_appears p = not(equali_appears_aux p)

let corec[iterator(true)] equali p = match p with 
(* of integer parts *)
  [], [] -> true
| h1 :: t1, h2 :: t2 -> h1 = h2 && equali (t1, t2)
| 0 :: t1, [] -> equali (t1, [])
| [], 0 :: t2 -> equali (t2, [])
| x -> false

let equal p1 p2 = match p1, p2 with
  (i1, j1), (i2, j2) -> equali (i1, i2) && equalf (j1, j2)

let r1 = equali ([1;2], [3])
let r2 = equali ([1;2], [1;2])
let rec b = 2 :: b
let r2a = let rec a = 2 :: 2 :: a in a = b

let rec zeros = 0 :: zeros
let r3 = equali(zeros, [])
let rec ones = 1 :: ones
let r4 = equali(ones, [])

let rec of_int i = 
  match i with
      0 -> []
    | i -> i mod p :: of_int (i / p)

(**** Normalization ****)

let corec[constructor] normalizei i = 
  if equali(i, []) then [] else
  match i with i :: t -> i :: normalizei t

let r5 = normalizei []
let r6 = normalizei [0;0;1]
let r7 = normalizei zeros
let r8 = normalizei ones
let normalize n = match n with i, f ->
  normalizei i, normalizei f

(**** Euclid ****)
let rec euclid p a b =
(* assumes b and p prime together
   finds d in [| 0 ; p-1 |] such that a = (b * d) mod p
   i.e. there exists e st b * d + p * e = a *)
(* Look up Euclid's algo, but for now brute force: *)
   let a = if a >= 0 then a mod p else a mod p + p in
   let rec tryn d =
     if d < p then 
        if (b * d) mod p = a then d else tryn (d+1)
     else failwith "Error in Euclid's algorithm"
   in tryn 0

(**** Shifting ****)
let rec shift n i = (* multiplies i by p^n *)
  if n = 0 then i
  else if n > 0 then 
    (match i with
      l, [] -> shift (n-1) (0 :: l, [])
    | l, hr :: tr -> shift (n-1) (hr :: l, tr))
  else (* n < 0 *) 
    (match i with
      [], r -> shift (n+1) ([], 0 :: r)
    | hl :: tl, r -> shift (n+1) (tl, hl :: r))

(**** From rational ****)
let corec[constructor] from_rationali q = match q with (a, b) ->
  (* supposes that b is not dividable by p, and outputs an integer part *)
  if a = 0 then []
  else let d = euclid p a b in
       d :: from_rationali ((a - b * d) / p, b)

let rec from_rational a b = (* creates a/b in base p *)
  let rec divide_by_p b =
    if b mod p = 0 then 
    (match divide_by_p (b/p) with resb, resn -> (resb, resn + 1))
    else b, 0 
  in
    match divide_by_p b with b2, n ->
    let res = from_rationali (a, b2) in
    shift (-n) (res, [])

let i0 = from_rational 8 3
let i1 = from_rational 8 21

(**** To string ****)
type 'a sep = I1 | I2 of 'a * sep | I3 of 'a list * 'a list
let corec[separate] separate i = match i with
  [] -> I1
| i :: t -> I2(i, separate t)

let rec string_of_lis l = match l with
  [] -> ""
| i :: t -> string_of_int i ^ string_of_lis t

let to_string n = match n with (i, f) -> (
  match separate i with
    I3(l1, []) -> string_of_lis (rev l1)
  | I3(l1, l2) -> 
    "(" ^ string_of_lis (rev l2) ^ ")" ^ string_of_lis (rev l1)
) ^ "." ^ string_of_lis (rev f)
     
let printp n = print (to_string n); print "\n"

let r9 = printp i0
let r10 = printp i1

(**** To float ****)
let corec[gaussian] to_floati i = match i with
    [] -> 0.
  | h :: t -> float_of_int h +. float_of_int p *. to_floati t
let rec to_floatf f = match f with
    [] -> 0.
  | h :: t -> (float_of_int h +. to_floatf t) /. float_of_int p
let to_float n = match n with (i, f) -> to_floati i +. to_floatf f


let r11 = to_float i0
let r12 = 8. /. 3. 
let r13 = to_float i1
let r14 = 8. /. 21. 

(**** Addition ****)
let corec[constructor] addi arg = match arg with
    [], [], c -> if c = 0 then []
      else c mod p :: addi ([], [], c/p)
  | h :: t, [], c -> addi (h :: t, [0], c)
  | [], h :: t, c -> addi ([0], h :: t, c)
  | hi :: ti, hj :: tj, c -> 
    let res = hi + hj + c in
    res mod p :: addi (ti, tj, res / p)
let rec addf j1 j2 = match j1, j2 with
    [], [] -> [], 0
  | h :: t, [] -> h :: t, 0
  | [], h :: t -> h :: t, 0
  | h1 :: t1, h2 :: t2 ->
    (match addf t1 t2 with t, c ->
      let d = h1 + h2 + c in
      d mod p :: t, d/p)
let add n1 n2 = match n1, n2 with (i1, f1), (i2, f2) ->
    match addf f1 f2 with f, c ->
    let i = addi (i1, i2, c) in
    i, f

let r15 = to_float (add i0 i1)
let r16 = to_float i0 +. to_float i1
let a = match i0 with (a, b) -> a
let b = match i1 with (a, b) -> a

(**** Multiplication ****)
let corec[constructor] mult1 arg = match arg with
(* calculates i * j + c, where i is a p-adic integer, j is a digit and c a carry *)
    [], d, c -> if c = 0 then []
      else c mod p :: mult1 ([], d, c/p)
  | (hi :: ti), d, c -> let res = hi * d + c in
			res mod p :: mult1 (ti, d, res / p)

let corec[constructor] multi arg = match arg with
    n1, [], c -> c
  | n1, h2 :: t2, c ->
    match addi (mult1 (n1, h2, 0), c, 0) with
      [] -> 0 :: multi (n1, t2, 0)
    | hr :: tr -> hr :: multi (n1, t2, tr)

let rec len l = match l with
(* for finite lists *)
  [] -> 0
| i :: t -> 1 + len t

let mult n1 n2 = match n1, n2 with (i1, f1),(i2, f2) ->
  let l1 = len f1 in 
  let l2 = len f2 in
  (* remove the commas then add them back *)
  match shift l1 (i1, f1), shift l2 (i2, f2) with
      (i3, []), (i4, []) ->
        shift (- (l1 + l2)) (multi (i3, i4, []), [])
	  
let r17 = to_float (mult i0 i1)
let r18 = to_float i0 *. to_float i1

(**** Substraction ****)
let sub n1 n2 =
  add n1 (mult n2 (from_rational (-1) 1))

let r19 = to_float (sub i0 i1)
let r20 = to_float i0 -. to_float i1

(**** Division ****)
let corec[constructor] divi arg = match arg with
    x, [] -> failwith "cannot divide by zero (on p-adic numbers)"
  | [], x -> []
  | hi :: ti, hj :: tj -> 
    let i = hi :: ti in let j = hj :: tj in let d = euclid p hi hj in
    match sub (i, []) (mult1 (j, d, 0), []) with
	[], [] -> d :: divi ([], j)
      | 0 :: t, [] -> d :: divi (t, j)
    (*| _ -> assert false*)

let div n1 n2 = match n1, n2 with (i1, f1), (i2, f2) ->
    if normalize n2 = ([], [])
    then print "Error: cannot divide by zero; detected ahead\n"; [], []
    else
    let l1 = len f1 in
    let l2 = len f2 in
    (* remove the commas then add them back *)
    match (shift l1 (i1, f1)), (shift l2 (i2, f2)) with
      (i3, []), (i4, []) ->
        shift (- (l1 - l2)) (divi (i3, i4), [])

let r21 = to_float (div i0 i1)
let r22 = to_float i0 /. to_float i1
let r23 = div i0 ([],[])
let r24 = div i0 (zeros, [0;0])
let r25 = normalize(zeros, [])
let r26 = normalize(zeros, [0;0])

let r27 = printp (div i0 i1)
let r28 = printp (div i1 i0)
let r29 = printp (normalize (div i0 i1))
let r30 = printp (normalize (div i1 i0))

