(* type terminal = string
type nonterminal = string *)
type production =
  Epsilon 
| T of string 
| N of string
| Seq of production * production
| Alt of production * production

(* parsing bug: can't write = function *)
let productions s = match s with
  | "A" -> Epsilon
  | "B" -> N "C"
  | "C" -> Alt(N "B", N "A")
  | "D" -> T "d"
  | "E" -> Alt(N "E", N "F")
  | "F" -> N "E"

let corec[iterator false] nullable p = match p with
  | Epsilon -> true
  | T t -> false
  | N n -> nullable (productions n)
  | Seq(prod1, prod2) -> nullable prod1 && nullable prod2
  | Alt(prod1, prod2) -> nullable prod1 || nullable prod2

let r1 = nullable (productions "A")
let r1 = nullable (productions "B")
let r1 = nullable (productions "D")
let r1 = nullable (productions "E")

(* non seulement nullable, mais aussi first et follow
   'a list est-il covariant: il y a un calcul de covariant
   [argument de ref est invariant] -> calcul de point fixe
   dans un treillis en diamant variant/invariant/covariant
   -> inferer
   existe-t-il *)



(* mutable data fifo a =
   Empty { length: int; tail: () }
 | NonEmpty { length: int; tail: dynamic }

les variables ne sont pas mutables, mais les champs sont mutables.
D'ou on peut creer des structures cycliques.
*)

(* let g f = match fifo with 
     Empty(&l, t) ->
*) 

(* Caml light: 
     type list = Cons of int * mutable list
     match l with 
       Cons(i, m) ->   m <- qqch
*)

(* Compiler vers du code Caml proche de Fix??
   -> compiler le let corec vers un appel a la librairie Fix *)



(*
>       Caml Light version 0.80

#type 'a list = Nil | Cons of mutable 'a * 'a list;;
Type list defined.
#let f l1 l2 = match l1 with Nil -> () | Cons(h1, t1) -> t1 <- l2;;
Toplevel input:
>let f l1 l2 = match l1 with Nil -> () | Cons(h1, t1) -> t1 <- l2;;
>                                                        ^^^^^^^^
The identifier t1 is not mutable.
#let f l1 l2 = match l1 with Nil -> () | Cons p1 -> p1 <- (1, l2);;
f : int list -> int list -> unit = <fun>
#f [1] [2];;
Toplevel input:
>f [1] [2];;
>  ^^^
This expression has type int builtin__list,
but is used with type int list.
#f (Cons(1, Nil)) (Cons(2, Nil));;
- : unit = ()
#let l1 = Cons(1, Nil);;
l1 : int list = Cons (1, Nil)
#f l1 (Cons(2, Nil));;
- : unit = ()
#l1;;
- : int list = Cons (1, Cons (2, Nil))
*)
