open Ast
open Environment
open Printing

let rec unknown2var (e : expr) = match e with
(* Only the ones that correspond to a constructor qualify *)
| Unknown (Symbol x) -> Var x
| Var _ | Int _ | Float _ | Strg _ | Bool _ | Unit | Inj(_, None) -> e
| Tuple(el) -> Tuple(List.map unknown2var el)
| Inj(i, Some e1) -> Inj(i, Some (unknown2var e1))
| Fun _ | FunType _ | FunCorec _ | Function _ | LetType _ |
  LetrecType _ | LetcorecType _ | App _ | Seq _ |
  If _ | While _ | For _ | Assg _ | Eq _ | Neq _ | Lt _ | 
  Le _ | Gt _ | Ge _ | Plus _ | Minus _ | Mul _ | Div _ | Mod _ |
  PlusF _ | MinusF _ | MulF _ | DivF _ | Concat _ | Not _ |
  And _ | Or _ | Match _ | Dummy | Native _ | Symbol _ | Unknown _
    -> failwith "unknown2var"

let solve name env eqs =
  let new_eqs = List.map (fun (id, rhs) -> (id, unknown2var rhs)) eqs in
  let new_env =
    List.fold_left
      (fun cur_env (id, rhs) -> Environment.bind id rhs cur_env)
      env new_eqs in
  (Environment.lookup name new_env, new_env)
