
open Ast

module E = Equations_types

let hd (v : expr) : expr =
  match v with
    | List l ->
      (match l with
        | [] -> Ast.runtime "head of empty list"
        | x :: _ -> x)
    | _ -> Ast.runtime "head of non-list"

let tl (v : expr) : expr =
  match v with
    | List l ->
      (match l with
        | [] -> Ast.runtime "tail of empty list"
        | _ :: t -> List t)
    | _ -> Ast.runtime "tail of non-list"

let print (v : expr) : expr =
  match v with
    | Strg s -> Printf.printf "%s" s; Unit
    | Int n -> Printf.printf "%d" n; Unit
    | Bool b -> Printf.printf "%B" b; Unit
    | _ -> 
      print_string( Printing.to_string (v, Environment.Environment.empty));
      Unit
    (*| _ -> Ast.runtime "don't know how to print this"*)

let float_of_int2 (i : expr) : expr = match i with
  | Int(j) -> Float(float_of_int j)
  | _ -> Ast.runtime "Native float_of_int failed"
 
let string_of_int2 (i: expr) : expr = match i with
  | Int(j) -> Strg(string_of_int j)
  | _ -> Ast.runtime "Native string_of_int failed"

let natives = [
  ("hd", hd, let t = E.newVar() in Arrow (ListType t, t));
  ("tl", tl, let t = E.newVar() in Arrow (ListType t, ListType t));
  ("print", print, let t = E.newVar() in Arrow (t, UnitType));
  ("float_of_int", float_of_int2, Arrow(Integer, FloatType));
  ("string_of_int", string_of_int2, Arrow(Integer, String))
]