open Ast
open Environment
open Printing

let rec solve_aux eval_rhs env eqs (guesses: (id, expr) Hashtbl.t) =
    let b, envf = List.fold_left 
        (fun (b, cur_env) (x, rhs) ->
           let g = Hashtbl.find guesses x in
           let (ng, new_env), _, _ = eval_rhs (rhs, cur_env) guesses in
           Hashtbl.add guesses x ng;
          (* tests if guesses and new guesses are observationally the same *)
          b && (Equality.equal (g, cur_env) (ng, new_env)), new_env)
        (true, env) eqs in
    if b
    then guesses, envf
    else solve_aux eval_rhs envf eqs guesses

let solve eval bot (name:id) env eqs =
(* the order of the eqs, from bottom to top of the call tree, is ideal *)
  let guesses = Hashtbl.create (List.length eqs) in
  List.iter (fun (x, _) -> Hashtbl.add guesses x bot) eqs;
  let answers, env = (solve_aux eval env eqs guesses) in
  Hashtbl.find answers name, env
