open Fv

(* Substitution example *)
(************************)
(* Var the set of set variables
   C the final coalgebra for F X = Var + X * X

   h(x, t)
   C ----------> C
   |             /\
   gamma |             | alpha(x, t)
   V      F h    |
   Var + C * C ----> Var + C * C
*)

module Naive = struct
  module F = Fv.Naive
  type variable = string

  type tree = F.tree (* = algebra = coalgebra *)

  let (*co*)rec subst x t = function (* replace variable x by term t *)
    | F.Var v -> if v = x then t else F.Var v
    | F.App(t1, t2) -> F.App(subst x t t1, subst x t t2)
end

(* module Subst = *)
(* struct         *)
  type variable = string
      
  type 'b f = 'b Fv.f
  let fh = Fv.fh

  type equation  = variable * (variable f)
  type coalgebra = Fv.coalgebra
  type algebra   = VarM of variable
                   | AppM of (algebra ref) * (algebra ref)

  let equal = (==)

  let x = "x"
  let t = AppM(ref (VarM "y"), ref (VarM "y"))

  let gamma = Fv.gamma (* an isomorphism, basically the identity *)
  let alpha (*(x:variable) (t:algebra)*) (c:algebra f) : algebra =
    match c with
      | Fv.I1 v -> if v = x then t else VarM v
      | Fv.I2(a1, a2) -> AppM(ref a1, ref a2)

  let rec solve_aux (name:variable) (eqs:equation list)
      (seen:(variable * algebra) list)
      : algebra * (variable * algebra) list =
    try let res = List.assoc name seen in res, seen
    with Not_found ->
      match List.assoc name eqs with
        | Fv.I1 s -> (alpha (*x t*) (Fv.I1 s), seen)
        | Fv.I2(v1, v2) ->
          let rec res = AppM(t1', t2') (* No Dummy necessary!! *)
          and t1' = ref res
          and t2' = ref res in
	  let seen0 = (name, res)::seen in 
	  let (t1'', seen1) = solve_aux v1 eqs seen0 in t1' := t1'';
	  let (t2'', seen2) = solve_aux v2 eqs seen1 in t2' := t2'';
	  (res, seen2);;

  let solve (name:variable) (eqs:equation list) : algebra =
    fst (solve_aux name eqs [])
(* end *)

