(* Substitution example               *)
(* Solving the equations with toploop *)
(**************************************)
(* needs toplevellib.cma for compilation:
     ocamlc toplevellib.cma fv.cmo substitution.cmo subst_toploop.ml
   from OCaml 4.00:
     ocamlc -I +compiler-libs ocamlcommon.cma ocamlbytecomp.cma \
       ocamltoplevel.cma fv.cmo substitution.cmo subst_toploop.ml *)

   module S = Substitution                                            
   type variable = S.variable                                            
                                                                         
   type 'b f = 'b S.f                                                    
   let fh = S.fh                                                         
                                                                        
   type equation = S.equation                                            
   type coalgebra = S.coalgebra                                          
   type algebra = S.coalgebra                                            
                                                                        
   let equal = S.equal                                                   
                                                                        
   let x = "x"                                                           
   let t = Fv.App(Fv.Var "y", Fv.Var "y")                                
                                                                        
   let gamma = S.gamma                                                   
   let alpha (c:algebra f) : algebra = match c with                      
     | Fv.I1 v -> if v = x then t else Fv.Var v                          
     | Fv.I2(a1, a2) -> Fv.App(a1, a2)                                   

   let rec string_of_algebra = function
     | Fv.Var x -> "Fv.Var(\"" ^ x ^ "\")"
     | Fv.App(a1, a2) -> "Fv.App(" ^ (string_of_algebra a1) ^ ", " ^
                       (string_of_algebra a2) ^ ")"
   let string_of_equation = function
     | (v1, Fv.I1 v2) -> 
       v1 ^ " = " ^ (if v2 = x 
         then string_of_algebra t
         else "Fv.Var(\"" ^ v2 ^ "\")")
     | (v1, Fv.I2(v2, v3)) -> v1 ^ " = " ^ "Fv.App(" ^ v2 ^ ", " ^ v3 ^ ")" 
   let solve (name:variable) (eqs:equation list) =                   
     let code = "let res = (" ^ "let rec " ^
       (String.concat "\nand "                                        
          (List.map (fun e -> string_of_equation e) eqs))
          ^ "\nin " ^ name ^ ");;\n" in                                  
     (*print_string code;*)
     Topdirs.dir_directory "substitution";
     ignore(
       Toploop.execute_phrase true Format.err_formatter                
	 ((!Toploop.parse_toplevel_phrase)
	     (Lexing.from_string code)));
     Obj.obj (Toploop.getvalue "res")
(*end;;*)

(*
Toploop.execute_phrase true Format.err_formatter
  ((!Toploop.parse_toplevel_phrase)
      (Lexing.from_string 
	 "let a = 1;;"
      ));;
Obj.obj (Toploop.getvalue "a");;
*)

(****** This works ***********)
(* execute 'ocaml -I ..' then copy paste, line by line:

#load "../corecursive.cmo";;
#load "fv.cmo";;
#load "substitution.cmo";;
#load "subst_toploop.cmo";;

module Corecursive_SubstToploop = Corecursive.Corecursive(Subst_toploop);;

let rec t1 = Fv.App(Fv.Var("x"), t1);;
let rec t2 = Fv.App(Fv.Var("x"), Fv.App(Fv.Var("x"), t2));;
let rec t3 = Fv.App(Fv.Var("x"), t1);;
let rec t4 = Fv.App(Fv.Var("x"), Fv.App(Fv.Var("y"), t4));;

Corecursive_SubstToploop.main t1;;
Corecursive_SubstToploop.main t2;;
Corecursive_SubstToploop.main t3;;
Corecursive_SubstToploop.main t4;;
*)
