(* Free variables example *)
(**************************)
(* Var the set of set variables
   VarSet the set of sets of variables
   C the final coalgebra for F X = Var + X * X

   h
   C ----------> VarSet
   |             /\
   gamma |             | alpha
   V       F h   |
   Var + C * C ----> Var + VarSet * VarSet
*)
module Naive = struct
  type variable = string
  module VarSet = Set.Make (
    struct
      type t = variable
      let compare = Pervasives.compare
    end)

  type tree = Var of variable | App of tree * tree (* = coalgebra *)
  type varset = VarSet.t (* = algebra *)
  let (*co*)rec fv = function
    | Var v -> VarSet.singleton v
    | App(c1, c2) -> VarSet.union (fv c1) (fv c2)
end

(* module Fv = struct *)
  type variable = string

  module VarSet = Set.Make (
    struct
      type t = variable
      let compare = Pervasives.compare
    end )

  type 'b f = I1 of variable | I2 of 'b * 'b;;
  let fh (h: 'c * 'e -> 'a * 'e) 
      : 'c f * 'e -> 'a f * 'e = function
	| I1 v, e -> I1 v, e
	| I2(c1, c2), e -> 
          let a1, e1 = h (c1, e) in  (* could also fold on [c1; c2] *)
          let a2, e2 = h (c2, e1) in
          I2(a1, a2), e2
  let fh_simple (h: 'c -> 'a) (c : 'c f) =
    fst (fh (fun (c0, ()) -> h c0, ()) (c, ()))

  type equation  = variable * (variable f)
  type coalgebra = Var of variable | App of coalgebra * coalgebra
  type algebra   = VarSet.t

  let equal = (==)

  let gamma (c:coalgebra) : coalgebra f =
    match c with
      | Var v -> I1 v
      | App(c1, c2) -> I2(c1, c2);;
  let alpha (s:algebra f) : algebra =
    match s with
      | I1 v -> VarSet.singleton v
      | I2(s1, s2) -> VarSet.union s1 s2

  let rec solve_aux (eqs:equation list) (guesses:(variable * algebra) list) =
    let rec eval_rhs : variable f -> algebra =
      fun e -> alpha (fh_simple (fun v0 -> List.assoc v0 guesses) e)
      (* function | I1 z -> VarSet.singleton z
         | I2(v1, v2) -> VarSet.union (List.assoc v1 guesses) 
         (List.assoc v2 guesses) *)
    in
    let new_guesses = List.map (fun (x, eq) -> (x, eval_rhs eq)) eqs
    in if List.fold_left2 (fun b (_, g) (_, ng) -> 
      (* tests if guesses and new_guesses are observationally the same *)
      b && (VarSet.compare g ng = 0))
        true guesses new_guesses 
      then guesses
      else solve_aux eqs new_guesses

  let solve (name:variable) (eqs:equation list) : algebra =
    List.assoc name
      (solve_aux eqs (List.map (fun (x, _) -> x, VarSet.empty) eqs))
(* end *)
