
(* Substitution example *)
(* Alexandra's solution *)
(************************)
(* Var the set of set variables
   C the final coalgebra for F X = Var + X * X

              h
      C ----------> C^(Var*C)
      |                /\
gamma |                 | alpha
      V           F h   |
      Var + C * C ----> Var + C^(Var*C) * C^(Var*C)
*)

module Naive = struct
  module F = Fv.Naive
  type variable = string

  type tree = F.tree (* = algebra = coalgebra *)

  let (*co*)rec alexandra = function (* replace variable x by term t *)
    | F.Var v -> (fun x t -> if v = x then t else F.Var v)
    | F.App(t1, t2) -> (fun x t -> F.App(alexandra t1 x t, alexandra t2 x t))
end

(* module Alexandra = *)
(* struct             *)
  module S = Substitution
  type variable = string
      
  type 'b f = 'b S.f
  let fh = S.fh

  type equation  = variable * (variable f)
  type coalgebra = S.coalgebra
  type algebra   = variable * S.algebra -> S.algebra

  let equal = (==)

  let gamma = Fv.gamma
  let alpha (c:algebra f) : algebra = fun (x, t) ->
    match c with
      | Fv.I1 v -> if v = x then t else S.VarM v
      | Fv.I2(a1, a2) -> S.AppM(ref (a1 (x, t)), ref (a2 (x, t)))

  let rec solve_aux (name:variable) (eqs:equation list)
      (seen:(variable * algebra) list)
      : algebra * (variable * algebra) list =
    try let res = List.assoc name seen in res, seen
    with Not_found ->
      match List.assoc name eqs with
        | Fv.I1 s -> (alpha (Fv.I1 s), seen)
        | Fv.I2(v1, v2) ->
          let rec res = S.AppM(t1', t2')
          and t1' = ref res
          and t2' = ref res in
          let seen0 = (name, fun (x, t) -> res)::seen in  (* ?? *)
	  let (t1'', seen1) = solve_aux v1 eqs seen0 in
	  let (t2'', seen2) = solve_aux v2 eqs seen1 in
          ((fun (x, t) -> t1' := t1'' (x, t); t2' := t2'' (x, t); res),
           seen2);;

  let solve (name:variable) (eqs:equation list) : algebra =
    fst (solve_aux name eqs [])
(* end *)
