(* Streams and -1 example *)
(**************************)
(* Var the set of set variables
   S (streams) the final coalgebra for F X = int * X

   h
   S ----------> float
   |             /\
   gamma |             | alpha
   V    F h      |
   float * S ------> float * float
*)
module Naive = struct
  type variable = string

  let parameter = 2.
  let (*co*)rec stream = function
    | [] -> failwith "Finite list not allowed"
    | h::t -> h +. parameter *. (stream t)
end

(* module Stream = struct *)
  type variable = string
      
  type 'b f = float * 'b
  let fh (h: 'c * 'e -> 'a * 'e) 
      : 'c f * 'e -> 'a f * 'e = 
    fun ((i, c), e) -> 
      let a, e0 = h(c, e) in ((i, a), e0)

  type equation  = variable * (variable f);;
  type coalgebra = float list;; (* only infinite *)
  type algebra   = float;;

  let equal = (==)

  let parameter = 2. (* h (hd::tl) = hd + parameter * (h tl) *)

  let gamma (c:coalgebra) : coalgebra f =
    match c with
      | [] -> failwith "Finite list not allowed"
      | h::t -> h, t
  let alpha (a:algebra f) : algebra =
    (fst a) +. parameter *. (snd a)

  let string_of_equation = function
    (v1, (i, v2)) -> v1 ^ " = " ^ (string_of_float i) ^ " + " ^
                     (string_of_float parameter) ^ " * " ^ v2

  let linear_of_equation = function
    (v1, (i, v2)) -> [ v1, 1. ; v2, -. parameter ], -. i

  let solve (name:variable) (eqs:equation list) = (* TODO *)
      (* For now, a dummy value specially chosen for Xana :p *)
    print_string
      ("Equations: find " ^ name ^ " such that\n" ^
          (String.concat "\n"
             (List.map string_of_equation eqs)) ^
          "\n");
    Gaussian.solve name (List.map linear_of_equation eqs)
(* end *)
