(* Function on a stream that returns true iff it does not loop, i.e.,
   iff it is finite *)
(* lfp for (let rec finite = function [] -> true | h :: t -> finite t) *)
(*
   F X = 1 + X
*)

type variable = string

type 'b f = I1 of unit | I2 of 'b
let fh (h: 'c * 'e -> 'a * 'e) : 'c f * 'e -> 'a f * 'e =
  function (cf, e) -> match cf with
  | I1 () -> I1 (), e
  | I2 c  -> let a, e = h (c, e) in I2 a, e

type equation = variable * (variable f)
type coalgebra = int list (* TODO: replace int by a parameter, like 'd *)
type algebra = bool

let equal = (==)

let gamma (c:coalgebra) : coalgebra f = match c with
  | [] -> I1 ()
  | h :: t -> I2 t
let alpha (a:algebra f) : algebra = match a with
  | I1 () -> true
  | I2 b  -> b

let string_of_equation = function (v, vf) ->
  v ^ " = " ^ (match vf with I1 () -> "true" | I2 v2 -> v2)

let rec solve_aux name eqs seen = 
  if List.mem name seen then false
  else match List.assoc name eqs with
    | I1 () -> true
    | I2 name2 -> solve_aux name2 eqs (name :: seen)

let solve name eqs = solve_aux name eqs [ ]
  (* should use a heap for seen *)