(* Equality on streams *)
(* Example of a function taking two coinductive arguments *)
(***********************)
(* Remark: if the two streams are equal, true and false are
   both solutions of the equations!! *)
(*
  stream * stream -----------------------> bool
      |
      |
     gamma = 
      |
      V
  unit (* false *) + stream * stream ----------------> unit + bool

*)
(* module Equality = struct *)
  type variable = string
  
  type 'b f = I1 | I2 of 'b
  let fh (h : 'c * 'e -> 'a * 'e) : 'c f * 'e -> 'a f * 'e = function
    | I1, e -> I1, e
    | I2 c, e -> let a, e1 = h (c, e) in I2 a, e1

  type equation = variable * (variable f)
  type coalgebra = (int list) * (int list)
  type algebra = bool
  
  let equal (s1, t1) (s2, t2) =
    s1 == s2 && t1 == t2

  let gamma (c:coalgebra) : coalgebra f = match c with
    | h1::t1, h2::t2 -> 
        if h1 != h2 then I1 else I2 (t1, t2)
    | _ -> failwith "finite lists not authorized"
  let alpha (s:algebra f) : algebra = match s with
    | I1 -> false
    | I2 b -> b

  let string_of_equation = function
    | (v1, I1) -> v1 ^ " = false"
    | (v1, I2 v2) -> v1 ^ " = " ^ v2

  let solve (name:variable) (eqs:equation list) = 
  (* print the equations *)
    print_string
      ("Equations: find " ^ name ^ " such that\n" ^
          (String.concat "\n"
             (List.map string_of_equation eqs)) ^
          "\n");
    print_string "Result: ";
  (* we just test if I1 (= false) appears anywhere in the list *)
    List.fold_left (fun b (name, rhs) -> b && (rhs != I1)) true eqs

  type 'b rhs = Nil of 'b f | Cons of ('b f) rhs
    (* 'b f + ('b f) f + (('b f) f) f + ... ; sort of exponential *)
  let solve1 (name:variable) (eq:variable rhs) = match eq with
    | Nil(I1) -> false
    | _ -> true (* TODO *)

(*let solve2 (name:variable) (eqs:equation list)
   (*attempt 1*)
    match List.assoc v l with
    | I1 -> false
    | I2 v' when v = v' -> true
    | I2 v2 -> 
   (*attempt 2*)
    | (v', I1) :: _ when v = v' -> false
    | (v', I2 v'') :: _ when v = v' && v = v'' -> true
    | (v', I2 v2) :: (v2', c) :: t when v = v' && v2 = v2' ->
      solve (v, c) :: t *)
(* end *)