(* Descending Sequences *)
(************************)
(* TODO: ask Alexandra for the definitions again *)
(* S = (int list) the set of streams
   Functor F X = X + int * X

   h
   int * S -------------------------> S
   |                              /\
   gamma |                              | alpha
   V                  F h         |
   int * S + int * (int * S) -------> S + int * S
*)
module Naive = struct
  let (*co*)rec descending i = function
    | i::j::t -> 
      if i > j
      then (descending (i+1) (j::t)) 
      else i :: (descending i (j::t))
    | _ -> failwith "Finite lists not allowed"
 end

(* module Descending = *)
(* struct              *)
  type variable = string

  type 'b f = I1 of 'b | I2 of int * 'b
  let fh (h: 'c * 'e -> 'a * 'e) 
      : 'c f * 'e -> 'a f * 'e = function
	| I1 c, e -> let a1, e1 = h(c, e) in I1 a1, e1
	| I2(i, c), e -> 
          let a1, e1 = h (c, e) in
          I2(i, a1), e1

  type equation = variable * (variable f)
  type coalgebra = int * int list
  type algebra = int list

  let equal (i, s1) (j, s2) =
    (i = j) && (s1 == s2)

  let gamma (c:coalgebra) : coalgebra f = match c with
    | (i, x::s1) -> 
            (* to ensure that we do not recreate an y::s 
               with a different address *)
      (match s1 with
        | y::s -> if x > y 
          then I1(i+1, s1)
          else (I2(i, (1, s1)))
        | _ -> failwith "Finite lists not allowed")
    | _ -> failwith "Finite lists not allowed"
  let alpha (a:algebra f) : algebra = match a with
    | I1(s) -> s
    | I2(n, s) -> n::s

  let string_of_equation = function
    | (v1, I1 v2) -> v1 ^ " = " ^ v2
    | (v1, I2(i, v2)) -> v1 ^ " = " ^ 
      (string_of_int i) ^ " :: " ^ v2

  let solve (name:variable) (eqs:equation list) = (* TODO *)
    print_string
      ("Equations: find " ^ name ^ " such that\nlet rec " ^
          (String.concat "\n    and "
             (List.map string_of_equation eqs)) ^
          "\nin " ^ name ^ ";;");
    [] (* dummy *)
(* end *)
