(* Probabilities when flipping a coin *)
(*     Dexter's favorite              *)
(**************************************)
(* TODO: ask Dexter to explain it again *)
module Naive = struct
  type variable = string

  type tree = Heads | Tails | Flip of float * tree * tree
  let (*co*)rec probability = function
  (* computes the final probability of Tails *)
    | Heads -> 1.
    | Tails -> 0.
    | Flip(p, t1, t2) -> p *. (probability t1) +. (1. -. p) *. (probability t2)
end

(* module Probability = *)
(* struct               *)
  type variable = string

  type 'b f = IH | IT | IF of float * 'b * 'b
    (* we allow using a different coin at each flip *)
    (* float is probability to go in first subtree  *)
  let fh (h: 'c * 'e -> 'a * 'e) 
      : 'c f * 'e -> 'a f * 'e = function
	| IH, e -> IH, e
	| IT, e -> IT, e
	| IF(p, c1, c2), e ->
          let a1, e1 = h (c1, e) in
          let a2, e2 = h (c2, e1) in
          IF(p, a1, a2), e2

  type equation  = variable * (variable f)
  type coalgebra = Heads | Tails | Flip of float * coalgebra * coalgebra
  type algebra   = float

  let gamma (c:coalgebra) : coalgebra f =
    match c with
      | Heads -> IH
      | Tails -> IT
      | Flip(p, c1, c2) -> IF(p, c1, c2)
  let alpha (f:algebra f) : algebra = match f with
    | IH -> 1.
    | IT -> 0.
    | IF(p, f1, f2) -> p *. f1 +. (1. -. p) *. f2

  let equal = (==)

  let string_of_equation = function
    | (v1, IH) -> v1 ^ " = " ^ (string_of_float 1.)
    | (v1, IT) -> v1 ^ " = " ^ (string_of_float 0.)
    | (v1, IF(p, f1, f2)) -> v1 ^ " = " ^
      (string_of_float p) ^ " *. " ^ f1 ^ " +. " ^
      (string_of_float (1.-.p)) ^ " *. " ^ f2

  let linear_of_equation = function
    | (v1, IH) -> [v1, 1.], 1.
    | (v1, IT) -> [v1, 1.], 0.
    | (v1, IF(p, f1, f2)) ->
      [ v1, 1. ; f1, -.p ; f2, p -. 1. ], 0.

  let solve (name:variable) (eqs:equation list) = (* TODO *)
    print_string
      ("Equations: find " ^ name ^ " such that\n" ^
          (String.concat "\n"
             (List.map string_of_equation eqs)) ^
          "\n");
    Gaussian.solve name (List.map linear_of_equation eqs)
(* end *)
