open Probability

(* Outcome function *)
(********************)
module Naive = struct
  type tree = Heads | Tails | Flip of float * tree * tree
  type two = Zero | One
  type 'a stream = Cons of 'a * ('a stream)
  type outcome = OHeads | OTails | Bottom
  let (*co*)rec outcome = function (* tree -> two stream -> outcome *)
  (* computes the final probability of Tails *)
    | Heads -> (fun _ -> Heads)
    | Tails -> (fun _ -> Tails)
    | Flip(p, t1, t2) -> 
      (function
	| Cons(Zero, tl) -> outcome t1 tl 
	| Cons(One, tl)  -> outcome t2 tl)
  (* never explicitly returns Bottom *)
end

(* module Outcome = *)
(* struct           *)
  module P = Probability
  type variable = string

  type 'b f = 'b P.f
  let fh = P.fh

  type equation  = variable * (variable f)
  type coalgebra = P.coalgebra

  type two = Zero | One
  type 'a stream = Cons of 'a * ('a stream)
  type outcome = Heads | Tails | Bottom
  type algebra = two stream -> outcome

  let gamma = P.gamma
  let alpha (af : algebra f) : algebra = match af with
    | P.IH -> (fun _ -> Heads)
    | P.IT -> (fun _ -> Tails)
    | P.IF(_, a1, a2) -> (* a1 and a2 are in the algebra *)
      (function Cons(Zero, tl) -> a1 tl | Cons(One, tl) -> a2 tl)

  let equal = (==)

  let string_of_equation = function
    | (v1, P.IH) -> v1 ^ " = fun _ -> Heads"
    | (v1, P.IT) -> v1 ^ " = fun _ -> Tails"
    | (v1, P.IF(_, a1, a2)) -> v1 ^ " = " ^
      "fun H :: s -> " ^ a1 ^ " s " ^
      " | T :: s -> " ^ a2 ^ " s"

  let solve (name:variable) (eqs:equation list) = (* TODO *)
    print_string
      ("Equations: find " ^ name ^ " such that\n" ^
          (String.concat "\n"
             (List.map string_of_equation eqs)) ^
          "\n");
    fun s -> Heads (* dummy *)
(* end *)
