(* Almost the same: expected number of flips *)
(*********************************************)
module Naive = struct
  type tree = Heads | Tails | Flip of float * tree * tree
  let (*co*)rec flips = function
  (* computes the final probability of Tails *)
    | Heads | Tails -> 0.
    | Flip(p, t1, t2) -> 1. +. p *. (flips t1) +. (1. -. p) *. (flips t2)
end

(* module Flips = *)
(* struct         *)
  module P = Probability
  type variable = string
  type 'b f = 'b P.f
  let fh = P.fh
    
  type equation = variable * (variable f)
  type coalgebra = P.coalgebra
  type algebra = float
      
  let equal = (==)
    
  let gamma = P.gamma
  let alpha (f:algebra f) : algebra = match f with
    | P.IH | P.IT -> 0.
    | P.IF(p, f1, f2) -> 1. +. p *. f1 +. (1. -. p) *. f2

  let string_of_equation = function
    | (v1, P.IH) | (v1, P.IT) -> v1 ^ " = " ^ (string_of_float 0.)
    | (v1, P.IF(p, f1, f2)) -> v1 ^ " = " ^ (string_of_float 1.) ^ " + " ^
      (string_of_float p) ^ " *. " ^ f1 ^ " + " ^
      (string_of_float (1.-.p)) ^ " *. " ^ f2

  let linear_of_equation = function
    | (v1, P.IH) | (v1, P.IT) -> [v1, 1.], 0.
    | (v1, P.IF(p, f1, f2)) ->
        [ v1, 1. ; f1, -. p ; f2, p -. 1. ], -1.

  let solve (name:variable) (eqs:equation list) = (* TODO *)
    print_string
      ("Equations: find " ^ name ^ " such that\n" ^
          (String.concat "\n"
             (List.map string_of_equation eqs)) ^
          "\n");
    Gaussian.solve name (List.map linear_of_equation eqs)
(* end *)
