(*        Probability again                *)
(* More in line with how Dexter modeled it *)
(*******************************************)
module Naive = struct
  type variable = string

  type outcome = Heads | Tails
  type two = Zero | One
  type tree = Done of outcome | Flip of float * (two -> tree)
  let (*co*)rec dexter = function
  (* computes the final probability of Tails *)
    | Done Heads -> 0.
    | Done Tails -> 1.
    | Flip(p, f) -> p *. (dexter (f Zero)) +. (1. -. p) *. (dexter (f One))
end

(* module Dexter = *)
(* struct          *)
  type variable = string

  type outcome = Heads | Tails
  type two = Zero | One
  type 'b f = I1 of outcome | I2 of float * (two -> 'b)
    (* we allow using a different coin at each flip *)
    (* float is probability to go in first subtree  *)
  let fh (h: 'c * 'e -> 'a * 'e) 
      : 'c f * 'e -> 'a f * 'e = function
	| I1 o, e -> I1 o, e
	| I2(p, f), e -> (* interesting, could we do it if two was infinite? *)
        (* presumably, could be done with a fold it two
           is very large but non infinite *)
          let a1, e1 = h (f Zero, e) in
          let a2, e2 = h (f One, e1) in
          I2(p, function Zero -> a1 | One -> a2), e2

  type equation  = variable * (variable f)
  type coalgebra = Done of outcome | Flip of float * (two -> coalgebra)
  type algebra   = float

  let equal = (==)

  let gamma (c:coalgebra) : coalgebra f =
    match c with
      | Done o -> I1 o
      | Flip(p, f) -> I2(p, f)
  let alpha (f:algebra f) : algebra = match f with
    | I1 Heads -> 1.
    | I1 Tails -> 0.
    | I2(p, f) -> p *. (f Zero) +. (1. -. p) *. (f One)

  let string_of_equation = function
    | (v1, I1 Heads) -> v1 ^ " = " ^ (string_of_float 1.)
    | (v1, I1 Tails) -> v1 ^ " = " ^ (string_of_float 0.)
    | (v1, I2(p, f)) -> v1 ^ " = " ^
      (string_of_float p) ^ " *. " ^ (f Zero) ^ " + " ^
      (string_of_float (1.-.p)) ^ " *. " ^ (f One)

  let linear_of_equation = function
    | (v1, I1 Heads) -> [v1, 1.], 1.
    | (v1, I1 Tails) -> [v1, 1.], 0.
    | (v1, I2(p, f)) ->
      [ v1, 1. ; (f Zero), -.p ; (f One), p -. 1. ], 0.

  let solve (name:variable) (eqs:equation list) = (* TODO *)
    print_string
      ("Equations: find " ^ name ^ " such that\n" ^
          (String.concat "\n"
             (List.map string_of_equation eqs)) ^
          "\n");
    Gaussian.solve name (List.map linear_of_equation eqs)
(* end *)
