(* largely inspired from stream/stream.ml *)
open Common

type variable = string
      
  type 'b f = I1 | I2 of int (* p *) * int * 'b
  let fh (h: 'c * 'e -> 'a * 'e) 
      : 'c f * 'e -> 'a f * 'e = function
    | I1, e -> I1, e
    | I2(p, i, c), e -> 
      let a, e0 = h(c, e) in (I2(p, i, a), e0)

  type equation  = variable * (variable f);;
  type coalgebra = int (* p *) * int ilist;;
  type algebra   = float;;

  let equal (p1, l1) (p2, l2) =
    p1 = p2 && l1 == l2

  let gamma (c:coalgebra) : coalgebra f =
    match c with
      | p, Nil -> I1
      | p, Cons(h, t) -> I2(p, h, (p, !t))
  let alpha (a:algebra f) : algebra = match a with
      | I1 -> 0.
      | I2(p, h, t) -> (float_of_int h) +. (float_of_int p) *. t

  let linear_of_equation = function
    | (v1, I1) -> [ v1, 1. ], 0.
    | (v1, I2(p, i, v2)) -> [ v1, 1. ; v2, -. (float_of_int p) ], 
                            -. (float_of_int i)

  let solve (name:variable) (eqs:equation list) =
    Gaussian.solve name (List.map linear_of_equation eqs)
