(* sum of two padic integers *)

open Common
module A = Common.Algebra
type variable = A.variable
type 'b f = 'b A.f
let fh = A.fh
type equation = A.equation
type algebra = A.algebra
let alpha = A.alpha
let solve = A.solve

module Corecursive_Equal = Corecursive.Corecursive(Equal)

type coalgebra = int ilist
let equal i j = Corecursive_Equal.main (i, j)
(* very important! equal_ilist would not normalize anything!! *)

let rec gamma = function
  | Nil -> I1 Nil
  | i when equal i Nil -> I1 Nil
  | Cons(h, t) -> I2(h, !t)
